/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sse.datamining.shared.impl;

import com.sap.sse.datamining.shared.GroupKey;
import com.sap.sse.datamining.shared.impl.AbstractGroupKey;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class CompoundGroupKey
extends AbstractGroupKey {
    private static final long serialVersionUID = -7902450253393172550L;
    private List<? extends GroupKey> keys;
    private boolean hasSubKeys;

    @Deprecated
    CompoundGroupKey() {
    }

    public CompoundGroupKey(List<? extends GroupKey> keys) {
        if (keys == null || keys.isEmpty()) {
            throw new IllegalArgumentException("The keys mustn't be null or empty");
        }
        this.keys = new ArrayList<GroupKey>(keys);
        this.hasSubKeys = this.keys.size() > 1;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public String asString() {
        void var4_7;
        StringBuilder builder = new StringBuilder();
        boolean first = true;
        int bracketCount = 0;
        for (GroupKey groupKey : this.keys) {
            if (!first) {
                builder.append('(');
                ++bracketCount;
            }
            builder.append(groupKey.asString());
            first = false;
        }
        boolean bl = false;
        while (var4_7 < bracketCount) {
            builder.append(")");
            ++var4_7;
        }
        return builder.toString();
    }

    @Override
    public boolean hasSubKeys() {
        return this.hasSubKeys;
    }

    @Override
    public int size() {
        int size = 0;
        for (GroupKey groupKey : this.keys) {
            size += groupKey.size();
        }
        return size;
    }

    @Override
    public List<? extends GroupKey> getKeys() {
        if (this.hasSubKeys) {
            return Collections.unmodifiableList(this.keys);
        }
        return Collections.singletonList(this.keys.get(0));
    }

    @Override
    public int compareTo(GroupKey key) {
        int result;
        if (key instanceof CompoundGroupKey) {
            CompoundGroupKey compoundGroupKey = (CompoundGroupKey)key;
            result = Integer.compare(this.keys.size(), compoundGroupKey.keys.size());
            if (result == 0) {
                int i = 0;
                while (i < this.keys.size()) {
                    result = this.keys.get(i).compareTo(compoundGroupKey.keys.get(i));
                    if (result == 0) {
                        ++i;
                        continue;
                    }
                    break;
                }
            }
        } else {
            result = super.compareTo(key);
        }
        return result;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.hasSubKeys ? 1231 : 1237);
        result = 31 * result + (this.keys == null ? 0 : this.keys.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        CompoundGroupKey other = (CompoundGroupKey)obj;
        if (this.hasSubKeys != other.hasSubKeys) {
            return false;
        }
        return !(this.keys == null ? other.keys != null : !this.keys.equals(other.keys));
    }
}

