/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.monitoring;

import com.sap.sailing.monitoring.AbstractPortMonitor;
import com.sap.sailing.monitoring.Activator;
import com.sap.sailing.monitoring.Endpoint;
import com.sap.sailing.monitoring.sysinfo.SystemInformation;
import com.sap.sailing.monitoring.sysinfo.SystemInformationImpl;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.mail.Address;
import javax.mail.Authenticator;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.NoSuchProviderException;
import javax.mail.PasswordAuthentication;
import javax.mail.Session;
import javax.mail.Transport;
import javax.mail.internet.AddressException;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeMessage;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleException;

public class OSGiRestartingPortMonitor
extends AbstractPortMonitor {
    private static final Logger log = Logger.getLogger(OSGiRestartingPortMonitor.class.getName());
    private final int DEFAULT_RETRY_COUNT_BEFORE_RESTART = 5;
    final int retryCountBeforeRestart;
    final Map<Endpoint, Integer> failureCount = new HashMap<Endpoint, Integer>();
    SystemInformation info = null;

    public OSGiRestartingPortMonitor(Properties properties) {
        super(properties);
        String[] props_bundles = properties.getProperty("monitor.bundles").split(",");
        this.retryCountBeforeRestart = Integer.valueOf(properties.getProperty("monitor.retrycount", "5").trim());
        int i = 0;
        while (i < this.endpoints.length) {
            this.endpoints[i].setBundleName(props_bundles[i].trim());
            ++i;
        }
        this.info = SystemInformationImpl.getInstance();
        log.info("Started and initialized OSGi monitor. State of SIGAR sysstats library: " + (this.info == null ? "INACTIVE" : "ACTIVE") + " java.library.path: " + System.getProperty("java.library.path"));
    }

    @Override
    public void handleFailure(Endpoint endpoint) {
        int myFailureCount = (this.failureCount.get(endpoint) == null ? 0 : this.failureCount.get(endpoint)) + 1;
        if (myFailureCount > this.retryCountBeforeRestart) {
            Bundle bundle;
            this.failureCount.remove(endpoint);
            boolean sysinfo_available = true;
            if (this.info == null) {
                sysinfo_available = false;
            }
            if ((bundle = this.getBundleByName(endpoint.getBundleName())) == null) {
                log.severe("Couldn't find bundle " + endpoint.getBundleName() + ". Cannot restart. Please check monitoring.properties file");
                try {
                    this.sendMail(endpoint, "Couldn't find non-responsive bundle " + endpoint.getBundleName(), "Couldn't find bundle " + endpoint.getBundleName() + ". Cannot restart. Please check monitoring.properties file");
                }
                catch (Exception e) {
                    e.printStackTrace();
                    log.log(Level.SEVERE, "handleFailure", e);
                }
            } else {
                String info_before_restart = "";
                if (sysinfo_available) {
                    info_before_restart = this.info.toString();
                }
                if (bundle.getState() == 2 || bundle.getState() == 4 || (long)bundle.getState() == 32L) {
                    try {
                        bundle.stop();
                    }
                    catch (BundleException e) {
                        log.severe("Could not stop " + endpoint.getBundleName() + " trying to start anyway.");
                    }
                    try {
                        bundle.start();
                    }
                    catch (BundleException e) {
                        e.printStackTrace();
                        log.severe("Could not start " + endpoint.getBundleName() + "! Handler will try again next time");
                    }
                } else {
                    log.severe("Bundle " + endpoint.getBundleName() + " not in state STARTED or ACTIVE (State: +" + bundle.getState() + ")! Restart not performed.");
                }
                String subject = "Bundle " + endpoint.getBundleName() + " restarted";
                log.info(subject);
                if (!endpoint.hasFailed() && this.properties.getProperty("mail.enabled", "true").equalsIgnoreCase("true")) {
                    log.info("Sending mail to " + this.properties.getProperty("mail.to") + " saying that bundle " + endpoint.getBundleName() + " was restarted");
                    try {
                        String content = "The Bundle " + endpoint.getBundleName() + " has been restarted - check on " + endpoint + " didn't respond!\n" + "This Mail won't be sent again if service continues to fail.";
                        if (sysinfo_available) {
                            content = String.valueOf(content) + "\n\nSystem Information BEFORE restart:\n" + info_before_restart;
                            content = String.valueOf(content) + "\n\nSystem information AFTER restart:\n" + this.info.toString();
                        } else {
                            content = String.valueOf(content) + "\n\nSystem information NOT available due to an error in the library (in most cases caused by native libs not being available)";
                        }
                        this.sendMail(endpoint, subject, content);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        log.throwing(this.getClass().getName(), "handleFailure", e);
                    }
                }
            }
        } else {
            log.info("Endpoint " + endpoint + " failed the " + myFailureCount + "th time since the last success. Trying again.");
            this.failureCount.put(endpoint, myFailureCount);
        }
    }

    private void sendMail(Endpoint endpoint, String subject, String content) throws MessagingException, AddressException, NoSuchProviderException {
        Session session = Session.getInstance((Properties)this.properties, (Authenticator)new SMTPAuthenticator());
        MimeMessage msg = new MimeMessage(session);
        msg.setFrom((Address)new InternetAddress("root@sapsailing.com"));
        msg.setSubject(subject);
        msg.setContent((Object)content, "text/plain");
        String[] stringArray = this.properties.getProperty("mail.to").split(",");
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String mailAddress = stringArray[n2];
            msg.addRecipient(Message.RecipientType.TO, (Address)new InternetAddress(mailAddress.trim()));
            ++n2;
        }
        Transport ts = session.getTransport();
        ts.connect();
        ts.sendMessage((Message)msg, msg.getRecipients(Message.RecipientType.TO));
        ts.close();
    }

    @Override
    public void handleConnection(Endpoint endpoint) {
        Integer previousFailureCount = this.failureCount.remove(endpoint);
        if (previousFailureCount != null) {
            log.info("endpoint " + endpoint + " recovered after " + previousFailureCount + " failures");
        }
    }

    protected Bundle getBundleByName(String name) {
        Bundle[] bundleArray = Activator.getContext().getBundles();
        int n = bundleArray.length;
        int n2 = 0;
        while (n2 < n) {
            Bundle bundle = bundleArray[n2];
            if (bundle.getSymbolicName().equalsIgnoreCase(name)) {
                return bundle;
            }
            ++n2;
        }
        return null;
    }

    private class SMTPAuthenticator
    extends Authenticator {
        private SMTPAuthenticator() {
        }

        public PasswordAuthentication getPasswordAuthentication() {
            String username = OSGiRestartingPortMonitor.this.properties.getProperty("mail.smtp.user");
            String password = OSGiRestartingPortMonitor.this.properties.getProperty("mail.smtp.password");
            return new PasswordAuthentication(username, password);
        }
    }
}

