/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.monitoring;

import com.sap.sailing.monitoring.Endpoint;
import com.sap.sailing.monitoring.EndpointImpl;
import java.io.IOException;
import java.net.ConnectException;
import java.net.HttpURLConnection;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.MalformedURLException;
import java.net.Socket;
import java.net.SocketTimeoutException;
import java.net.URL;
import java.util.Properties;
import java.util.logging.Logger;

public abstract class AbstractPortMonitor
extends Thread {
    Logger log = Logger.getLogger(AbstractPortMonitor.class.getName());
    private int timeout = 1000;
    private int graceful = 5000;
    private int pause = 1000;
    protected Endpoint[] endpoints = null;
    protected int interval;
    boolean started = false;
    boolean paused = false;
    private long lastmillis;
    private Endpoint currentendpoint;
    protected Properties properties;

    public AbstractPortMonitor(Properties properties) {
        String[] prop_endpoints = properties.getProperty("monitor.endpoints").split(",");
        this.endpoints = new Endpoint[prop_endpoints.length];
        int i = 0;
        while (i < prop_endpoints.length) {
            EndpointImpl e;
            if (prop_endpoints[i].trim().startsWith("http")) {
                try {
                    URL url = new URL(prop_endpoints[i].trim());
                    e = new EndpointImpl(url);
                    this.endpoints[i] = e;
                }
                catch (MalformedURLException ex) {
                    this.log.severe("Could not parse endpoint definition " + prop_endpoints[i]);
                }
            } else {
                String[] data = prop_endpoints[i].split(":");
                try {
                    e = new EndpointImpl(new InetSocketAddress(InetAddress.getByName(data[0].trim()), Integer.parseInt(data[1].trim())));
                    this.endpoints[i] = e;
                }
                catch (Exception ex) {
                    this.log.severe("Could not parse endpoint definition " + prop_endpoints[i]);
                }
            }
            ++i;
        }
        this.interval = Integer.parseInt(properties.getProperty("monitor.interval", "" + this.interval).trim());
        this.timeout = Integer.parseInt(properties.getProperty("monitor.timeout", "" + this.timeout).trim());
        this.graceful = Integer.parseInt(properties.getProperty("monitor.gracetime", "" + this.graceful).trim());
        this.pause = Integer.parseInt(properties.getProperty("monitor.pause", "" + this.pause).trim());
        this.started = true;
        this.properties = properties;
        this.log.info("Initialized monitoring!");
    }

    public void startMonitoring() {
        this.start();
    }

    @Override
    public void run() {
        try {
            Thread.sleep(this.graceful);
            while (this.started) {
                block19: {
                    if (!this.paused) {
                        long currentmillis = System.currentTimeMillis();
                        try {
                            if (currentmillis < this.lastmillis + (long)this.interval + (long)(100 * this.endpoints.length)) break block19;
                            int i = 0;
                            while (i < this.endpoints.length) {
                                block20: {
                                    this.currentendpoint = this.endpoints[i];
                                    try {
                                        if (!this.currentendpoint.isURL()) {
                                            Socket sn = new Socket();
                                            sn.connect(this.currentendpoint.getAddress(), this.timeout);
                                            sn.close();
                                        } else {
                                            System.setProperty("http.keepAlive", "false");
                                            HttpURLConnection conn = (HttpURLConnection)this.currentendpoint.getURL().openConnection();
                                            conn.setConnectTimeout(this.timeout);
                                            conn.setRequestMethod("GET");
                                            conn.connect();
                                            int code = conn.getResponseCode();
                                            try {
                                                conn.getInputStream().close();
                                            }
                                            catch (Exception exception) {
                                                // empty catch block
                                            }
                                            conn.disconnect();
                                            if (code != 200) {
                                                throw new ConnectException("Could not successfully connect to endpoint " + this.currentendpoint.toString());
                                            }
                                        }
                                        this.log.finest("Connection succeeded to " + this.currentendpoint.toString());
                                        this.handleConnection(this.currentendpoint);
                                        this.lastmillis = System.currentTimeMillis();
                                        this.currentendpoint.setSuccess(System.currentTimeMillis());
                                    }
                                    catch (ConnectException | SocketTimeoutException ex) {
                                        boolean handle = true;
                                        if (this.currentendpoint.hasFailed()) {
                                            if (this.currentendpoint.lastFailed() + (long)Integer.parseInt(this.properties.getProperty("monitor.wait_after_failure", "60000")) > System.currentTimeMillis()) {
                                                handle = false;
                                            } else {
                                                this.log.info("Service has failed (" + this.currentendpoint.toString() + ") before and gracetime is over. Calling failure handler again.");
                                            }
                                        } else {
                                            this.log.info("Connection FAILED to " + this.currentendpoint.toString());
                                        }
                                        if (!handle) break block20;
                                        this.handleFailure(this.currentendpoint);
                                        this.lastmillis = System.currentTimeMillis();
                                        this.currentendpoint.setFailure(System.currentTimeMillis());
                                    }
                                }
                                ++i;
                            }
                        }
                        catch (IOException ex) {
                            ex.printStackTrace();
                        }
                    } else {
                        this.log.info("Pausing...");
                    }
                }
                Thread.sleep(this.pause);
            }
        }
        catch (InterruptedException ex) {
            System.err.println("Interrupted");
        }
    }

    public void stopMonitoring() {
        this.started = false;
    }

    public abstract void handleFailure(Endpoint var1);

    public abstract void handleConnection(Endpoint var1);
}

