/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sse.gwt.settings;

import com.google.gwt.http.client.UrlBuilder;
import com.google.gwt.i18n.client.LocaleInfo;
import com.google.gwt.user.client.Window;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;

public class UrlBuilderUtil {
    private static final Logger log = Logger.getLogger(UrlBuilderUtil.class.getName());

    public static UrlBuilder createUrlBuilderFromCurrentLocationWithCleanParameters() {
        UrlBuilder urlBuilder = Window.Location.createUrlBuilder();
        for (String parameterName : Window.Location.getParameterMap().keySet()) {
            if ("gwt.codesvr".equals(parameterName) || LocaleInfo.getLocaleQueryParam().equals(parameterName)) continue;
            urlBuilder.removeParameter(parameterName);
        }
        urlBuilder.setHash(null);
        return urlBuilder;
    }

    public static UrlBuilder createUrlBuilderFromBaseURLAndPathWithCleanParameters(String baseUrl, String path) {
        int colonIndex = baseUrl.indexOf(58);
        String protocol = colonIndex >= 0 ? baseUrl.substring(0, colonIndex) : "http";
        int doubleSlashIndex = baseUrl.indexOf("//");
        String baseURLWithoutProtocol = doubleSlashIndex >= 0 ? baseUrl.substring(doubleSlashIndex + 2) : baseUrl;
        int pathIndex = baseURLWithoutProtocol.indexOf(47);
        String hostAndPort = pathIndex >= 0 ? baseURLWithoutProtocol.substring(0, pathIndex) : baseURLWithoutProtocol;
        String pathPrefix = pathIndex >= 0 ? baseURLWithoutProtocol.substring(pathIndex + 1) : "";
        int portColonIndex = hostAndPort.indexOf(58);
        String host = portColonIndex >= 0 ? hostAndPort.substring(0, portColonIndex) : hostAndPort;
        int port = Integer.MIN_VALUE;
        if (portColonIndex >= 0) {
            try {
                port = Integer.valueOf(hostAndPort.substring(portColonIndex + 1));
            }
            catch (Exception e) {
                log.log(Level.SEVERE, "Error while parsing port for baseUrl: " + baseUrl, e);
            }
        }
        StringBuilder pathBuilder = new StringBuilder(pathPrefix);
        if (pathPrefix.endsWith("/")) {
            pathBuilder.append(path.startsWith("/") ? path.substring(1) : path);
        } else {
            if (!path.startsWith("/")) {
                pathBuilder.append("/");
            }
            pathBuilder.append(path);
        }
        UrlBuilder urlBuilder = UrlBuilderUtil.createUrlBuilderFromCurrentLocationWithCleanParameters();
        urlBuilder.setProtocol(protocol);
        urlBuilder.setHost(host);
        urlBuilder.setPath(pathBuilder.toString());
        urlBuilder.setPort(port);
        return urlBuilder;
    }

    public static UrlBuilder createUrlBuilderFromCurrentLocationWithCleanParametersAndPath(String path) {
        return UrlBuilderUtil.createUrlBuilderFromCurrentLocationWithCleanParameters().setPath(path);
    }

    public static UrlBuilder createUrlBuilderFromCurrentLocationWithCleanParametersAndPathAndHash(String path, String hash) {
        return UrlBuilderUtil.createUrlBuilderFromCurrentLocationWithCleanParametersAndPath(path).setHash(hash);
    }

    public static UrlBuilder createUrlBuilderWithPathAndParameters(String path, Map<String, String> parameters) {
        UrlBuilder urlBuilder = UrlBuilderUtil.createUrlBuilderFromCurrentLocationWithCleanParametersAndPath(path);
        for (Map.Entry<String, String> entry : parameters.entrySet()) {
            urlBuilder.setParameter(entry.getKey(), new String[]{entry.getValue()});
        }
        return urlBuilder;
    }

    public static UrlBuilder createUrlBuilderWithPathAndHashAndParameters(String path, String hash, Map<String, String> parameters) {
        return UrlBuilderUtil.createUrlBuilderWithPathAndParameters(path, parameters).setHash(hash);
    }
}

