/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sse.gwt.server;

import com.google.gwt.user.client.rpc.SerializationException;
import com.google.gwt.user.server.rpc.RPCRequest;
import com.google.gwt.user.server.rpc.RemoteServiceServlet;
import com.google.gwt.user.server.rpc.SerializationPolicy;
import com.sap.sse.common.Duration;
import com.sap.sse.common.TimePoint;
import com.sap.sse.common.Util;
import com.sap.sse.common.impl.MillisecondsTimePoint;
import com.sap.sse.util.HttpRequestUtils;
import java.io.IOException;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.shiro.SecurityUtils;
import org.apache.shiro.subject.Subject;

public abstract class ProxiedRemoteServiceServlet
extends RemoteServiceServlet {
    private static final long serialVersionUID = 5379097888921157936L;
    private static final Duration LOG_REQUESTS_TAKING_LONGER_THAN = Duration.ONE_SECOND.times(2L);
    private static final Logger logger = Logger.getLogger(ProxiedRemoteServiceServlet.class.getName());
    private static final ThreadLocal<Util.Triple<RPCRequest, TimePoint, TimePoint>> processingStartAndFinishTime = new ThreadLocal();
    private static final String[] SENSITIVE_PARAMETER_NAME_SUBSTRINGS = new String[]{"secret", "pass", "pw", "token", "code", "credentials"};

    protected SerializationPolicy doGetSerializationPolicy(HttpServletRequest request, String moduleBaseURL, String strongName) {
        String moduleBaseURLHdr = request.getHeader("X-GWT-Module-Base");
        if (moduleBaseURLHdr != null) {
            moduleBaseURL = moduleBaseURLHdr;
        }
        return super.doGetSerializationPolicy(request, moduleBaseURL, strongName);
    }

    protected void doUnexpectedFailure(Throwable e) {
        if (e.getCause() != null && e.getCause().getClass().getName().matches("org\\.apache\\.shiro\\.authz\\..*[Aa]uth.*Exception") || e instanceof SerializationException && e.getMessage().matches("Type 'org\\.apache\\.shiro\\.authz\\..*[Aa]uth.*Exception' was not included in the set of types which can be serialized.*")) {
            HttpServletResponse servletResponse = this.getThreadLocalResponse();
            try {
                servletResponse.reset();
            }
            catch (IllegalStateException ex) {
                throw new RuntimeException("Unable to report failure", e);
            }
            ServletContext servletContext = this.getServletContext();
            servletContext.log("Exception while dispatching incoming RPC call", e.getCause() == null ? e : e.getCause());
            try {
                servletResponse.setContentType("text/plain");
                servletResponse.setStatus(401);
                try {
                    servletResponse.getOutputStream().write((e.getCause() == null ? e : e.getCause()).getLocalizedMessage().getBytes("UTF-8"));
                }
                catch (IllegalStateException ex) {
                    servletResponse.getWriter().write("Couldn't write exception");
                }
            }
            catch (IOException ex) {
                servletContext.log("respondWithUnexpectedFailure failed while sending the previous failure to the client", (Throwable)ex);
            }
        } else {
            super.doUnexpectedFailure(e);
        }
    }

    protected Locale getClientLocale() {
        String localeString;
        HttpServletRequest request = this.getThreadLocalRequest();
        if (request != null && (localeString = request.getHeader("X-Client-Locale")) != null && !localeString.isEmpty()) {
            try {
                return Locale.forLanguageTag(localeString);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return Locale.ENGLISH;
    }

    public String processCall(RPCRequest rpcRequest) throws SerializationException {
        TimePoint startOfRequestProcessing = this.beforeProcessCall();
        try {
            String string = super.processCall(rpcRequest);
            return string;
        }
        finally {
            this.afterProcessCall(rpcRequest, startOfRequestProcessing);
        }
    }

    protected TimePoint beforeProcessCall() {
        TimePoint startOfRequestProcessing = MillisecondsTimePoint.now();
        return startOfRequestProcessing;
    }

    protected void afterProcessCall(RPCRequest rpcRequest, TimePoint startOfRequestProcessing) {
        processingStartAndFinishTime.set((Util.Triple<RPCRequest, TimePoint, TimePoint>)new Util.Triple((Object)rpcRequest, (Object)startOfRequestProcessing, (Object)MillisecondsTimePoint.now()));
    }

    protected void service(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        super.service(req, resp);
        TimePoint afterSendingResultToResponse = MillisecondsTimePoint.now();
        Util.Triple<RPCRequest, TimePoint, TimePoint> startAndEndOfProcessing = processingStartAndFinishTime.get();
        if (startAndEndOfProcessing == null) {
            if (req.getMethod().equals("POST")) {
                logger.warning("A request with method POST from address " + HttpRequestUtils.getClientIP((HttpServletRequest)req) + " was processed. No timing information available. Perhaps there was an IncompatibleRemoteServiceException thrown, so the call was not processed.");
            }
        } else {
            Duration totalTime = ((TimePoint)startAndEndOfProcessing.getB()).until(afterSendingResultToResponse);
            if (totalTime.compareTo((Object)LOG_REQUESTS_TAKING_LONGER_THAN) > 0) {
                this.logRequest((RPCRequest)startAndEndOfProcessing.getA(), (TimePoint)startAndEndOfProcessing.getB(), (TimePoint)startAndEndOfProcessing.getC(), afterSendingResultToResponse);
            }
            processingStartAndFinishTime.set(null);
        }
    }

    private void logRequest(RPCRequest request, TimePoint startOfProcessing, TimePoint endOfProcessing, TimePoint afterSendingResultToResponse) {
        Duration processingDuration = startOfProcessing.until(endOfProcessing);
        Duration sendingToResponseDuration = endOfProcessing.until(afterSendingResultToResponse);
        Duration totalDuration = startOfProcessing.until(afterSendingResultToResponse);
        Subject subject = SecurityUtils.getSubject();
        String username = subject != null ? (subject.getPrincipal() == null ? null : subject.getPrincipal().toString()) : null;
        logger.log(Level.WARNING, "GWT RPC Request " + request.getMethod() + " by user " + username + " with parameters " + this.getRequestParameterValues(request) + " on " + (Object)((Object)this) + " took " + processingDuration + " to process, " + sendingToResponseDuration + " to send result into response, so " + totalDuration + " in total.");
    }

    private List<Object> getRequestParameterValues(RPCRequest request) {
        Method method = request.getMethod();
        ArrayList<Object> result = new ArrayList<Object>();
        int i = 0;
        Parameter[] parameterArray = method.getParameters();
        int n = parameterArray.length;
        int n2 = 0;
        while (n2 < n) {
            Parameter parameter = parameterArray[n2];
            if (!parameter.isNamePresent() || this.isSecuritySensitiveParameterName(parameter.getName())) {
                result.add("<hidden for security reasons>");
            } else {
                result.add(request.getParameters()[i]);
            }
            ++i;
            ++n2;
        }
        return result;
    }

    private boolean isSecuritySensitiveParameterName(String name) {
        String[] stringArray = SENSITIVE_PARAMETER_NAME_SUBSTRINGS;
        int n = SENSITIVE_PARAMETER_NAME_SUBSTRINGS.length;
        int n2 = 0;
        while (n2 < n) {
            String sensitiveSubstring = stringArray[n2];
            if (name.toLowerCase().contains(sensitiveSubstring)) {
                return true;
            }
            ++n2;
        }
        return false;
    }
}

