/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sse.gwt.dispatch.client.system.batching;

import com.google.gwt.core.client.Scheduler;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.sap.sse.gwt.dispatch.client.system.DispatchContext;
import com.sap.sse.gwt.dispatch.client.system.batching.BatchAction;
import com.sap.sse.gwt.dispatch.client.system.batching.BatchResult;
import com.sap.sse.gwt.dispatch.client.system.batching.DispatchCall;
import com.sap.sse.gwt.dispatch.client.system.batching.SplitScheduler;
import com.sap.sse.gwt.dispatch.shared.commands.Action;
import com.sap.sse.gwt.dispatch.shared.commands.Result;
import java.util.ArrayList;

public final class DispatchCallStack<CTX extends DispatchContext> {
    private final ArrayList<DispatchCall<?, ?, CTX>> actionQueue = new ArrayList();
    private BatchAction<CTX> batchAction;

    public <A extends Action<R, CTX>, R extends Result> void addCall(A action, AsyncCallback<R> callback) {
        assert (this.batchAction == null);
        this.actionQueue.add(new DispatchCall(action, callback));
    }

    public BatchAction<CTX> getBatchAction() {
        if (this.batchAction == null) {
            ArrayList actions = new ArrayList();
            for (DispatchCall<?, ?, CTX> dispatchCall : this.actionQueue) {
                actions.add(dispatchCall.getAction());
            }
            this.batchAction = new BatchAction(actions);
        }
        return this.batchAction;
    }

    public void fail(Throwable caught) {
        assert (caught != null);
        for (DispatchCall<?, ?, CTX> call : this.actionQueue) {
            call.getCallback().onFailure(caught);
        }
    }

    public void processResult(BatchResult batchResult, boolean processResultsScheduled) {
        assert (batchResult != null);
        int loop = 0;
        for (DispatchCall<?, ?, CTX> call : this.actionQueue) {
            Result result = batchResult.getResult(loop);
            Throwable exception = batchResult.getException(loop);
            CallbackCommand callbackCommand = new CallbackCommand(call, result, exception);
            if (processResultsScheduled) {
                SplitScheduler.get().schedule(callbackCommand);
            } else {
                callbackCommand.execute();
            }
            ++loop;
        }
    }

    private class CallbackCommand
    implements Scheduler.ScheduledCommand {
        private final DispatchCall call;
        private final Result result;
        private final Throwable exception;

        public CallbackCommand(DispatchCall call, Result result, Throwable exception) {
            this.call = call;
            this.result = result;
            this.exception = exception;
        }

        public void execute() {
            if (this.hasFailed()) {
                this.call.getCallback().onFailure(this.exception);
            } else {
                this.call.getCallback().onSuccess((Object)this.result);
            }
        }

        private boolean hasFailed() {
            return this.exception != null;
        }
    }
}

