/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sse.gwt.dispatch.client.system;

import com.google.gwt.user.client.rpc.AsyncCallback;
import com.sap.sse.gwt.client.ServiceRoutingProvider;
import com.sap.sse.gwt.dispatch.client.system.DispatchContext;
import com.sap.sse.gwt.dispatch.client.system.DispatchSystemAsync;
import com.sap.sse.gwt.dispatch.client.system.ProvidesServerTime;
import com.sap.sse.gwt.dispatch.client.system.batching.AutomaticBatchingDispatch;
import com.sap.sse.gwt.dispatch.client.system.caching.CachingDispatch;
import com.sap.sse.gwt.dispatch.client.transport.DefaultTransport;
import com.sap.sse.gwt.dispatch.shared.commands.Action;
import com.sap.sse.gwt.dispatch.shared.commands.Result;
import com.sap.sse.gwt.dispatch.shared.exceptions.DispatchException;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;

public abstract class DispatchSystemDefaultImpl<CTX extends DispatchContext>
implements DispatchSystemAsync<CTX>,
ProvidesServerTime {
    private final Logger LOG = Logger.getLogger(DispatchSystemDefaultImpl.class.getName());
    private final DefaultTransport<CTX> simpleDispatch;
    private final DispatchSystemAsync<CTX> defaultDispatch;
    private final Map<String, DispatchSystemAsync<CTX>> routingRegistry = new HashMap<String, DispatchSystemAsync<CTX>>();
    private final boolean processResultsScheduled;
    private final String dispatchRPCPath;

    public DispatchSystemDefaultImpl(String dispatchRPCPath) {
        this(dispatchRPCPath, false);
    }

    public DispatchSystemDefaultImpl(String dispatchRPCPath, boolean processResultsScheduled) {
        this.dispatchRPCPath = dispatchRPCPath;
        this.processResultsScheduled = processResultsScheduled;
        this.simpleDispatch = new DefaultTransport(dispatchRPCPath);
        this.defaultDispatch = new CachingDispatch<CTX>(new AutomaticBatchingDispatch<CTX>(this.simpleDispatch, processResultsScheduled));
        this.LOG.finest("Started default dispatch system for " + dispatchRPCPath);
    }

    private DispatchSystemAsync<CTX> createDispatchFor(String routing) {
        StringBuilder destinationUrlBuilder = new StringBuilder(this.dispatchRPCPath);
        if (routing != null && !routing.isEmpty()) {
            if (!this.dispatchRPCPath.endsWith("/")) {
                destinationUrlBuilder.append("/");
            }
            destinationUrlBuilder.append(routing.startsWith("/") ? routing.substring(1) : routing);
        }
        DefaultTransport transport = new DefaultTransport(destinationUrlBuilder.toString());
        CachingDispatch dispatch = new CachingDispatch(new AutomaticBatchingDispatch(transport, this.processResultsScheduled));
        return dispatch;
    }

    @Override
    public <R extends Result, A extends Action<R, CTX>> void execute(A action, final AsyncCallback<R> callback) {
        DispatchSystemAsync<CTX> dispatchToUse;
        AsyncCallback wrappedCallback = new AsyncCallback<R>(){

            public void onFailure(Throwable caught) {
                if (caught instanceof DispatchException) {
                    DispatchException sde = (DispatchException)caught;
                    DispatchSystemDefaultImpl.this.LOG.log(Level.SEVERE, "Server exception with id: " + sde.getExceptionId());
                }
                callback.onFailure(caught);
            }

            public void onSuccess(R result) {
                callback.onSuccess(result);
            }
        };
        if (action instanceof ServiceRoutingProvider) {
            ServiceRoutingProvider providesDispatchRoutingKey = (ServiceRoutingProvider)((Object)action);
            String routingPath = providesDispatchRoutingKey.routingSuffixPath();
            dispatchToUse = this.routingRegistry.computeIfAbsent(routingPath, this::createDispatchFor);
            this.LOG.fine("Using routed dispatch for path " + routingPath);
        } else {
            this.LOG.fine("Using default dispatch for " + action.getClass().getName());
            dispatchToUse = this.defaultDispatch;
        }
        dispatchToUse.execute(action, wrappedCallback);
    }

    @Override
    public Date getCurrentServerTime() {
        return new Date(System.currentTimeMillis() + this.simpleDispatch.getClientServerOffset());
    }
}

