/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sse.gwt.client.xdstorage.impl;

import com.google.gwt.core.client.GWT;
import com.google.gwt.core.client.JavaScriptObject;
import com.google.gwt.json.client.JSONNull;
import com.google.gwt.json.client.JSONNumber;
import com.google.gwt.json.client.JSONObject;
import com.google.gwt.json.client.JSONString;
import com.google.gwt.json.client.JSONValue;
import com.sap.sse.common.Util;
import com.sap.sse.gwt.client.Storage;
import com.sap.sse.gwt.client.StorageEvent;
import com.sap.sse.gwt.client.messaging.MessageEvent;
import com.sap.sse.gwt.client.messaging.MessageListener;
import com.sap.sse.gwt.client.xdstorage.impl.JavaScriptObjectWithID;
import com.sap.sse.gwt.client.xdstorage.impl.Request;
import com.sap.sse.gwt.client.xdstorage.impl.StorageOperation;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.UUID;

public class LocalStorageDrivenByMessageEvents
implements MessageListener<JavaScriptObject> {
    private final Storage localStorage;
    private final ArrayList<Util.Pair<Object, String>> windowsToForwardStorageEventsToAndTheirTargetOrigins;
    private final String acceptableCrossDomainStorageRequestOriginRegexp;

    public LocalStorageDrivenByMessageEvents(String acceptableCrossDomainStorageRequestOriginRegexp) {
        this.acceptableCrossDomainStorageRequestOriginRegexp = acceptableCrossDomainStorageRequestOriginRegexp;
        GWT.log((String)("Cross-domain storage requests will be accepted from " + (acceptableCrossDomainStorageRequestOriginRegexp != null ? "origins matching " + this.acceptableCrossDomainStorageRequestOriginRegexp : "no other origin")));
        this.localStorage = Storage.getLocalStorageIfSupported();
        this.windowsToForwardStorageEventsToAndTheirTargetOrigins = new ArrayList();
        Storage.addStorageEventHandler(storageEvent -> this.sendStorageEvent(storageEvent));
    }

    private void sendStorageEvent(StorageEvent storageEvent) {
        JSONObject storageEventResponse = new JSONObject();
        storageEventResponse.put("k", this.jsonStringOrJsonNull(storageEvent.getKey()));
        storageEventResponse.put("o", this.jsonStringOrJsonNull(storageEvent.getOldValue()));
        storageEventResponse.put("n", this.jsonStringOrJsonNull(storageEvent.getNewValue()));
        storageEventResponse.put("u", this.jsonStringOrJsonNull(storageEvent.getUrl()));
        GWT.log((String)("Forwarding cross-domain storage event to " + this.windowsToForwardStorageEventsToAndTheirTargetOrigins.size() + " handlers"));
        for (Util.Pair<Object, String> windowToForwardStorageEventToAndItsTargetOrigin : this.windowsToForwardStorageEventsToAndTheirTargetOrigins) {
            this.postMessage(windowToForwardStorageEventToAndItsTargetOrigin.getA(), storageEventResponse.getJavaScriptObject(), (String)windowToForwardStorageEventToAndItsTargetOrigin.getB());
        }
    }

    private native <T> void postMessage(Object var1, T var2, String var3);

    @Override
    public void onMessageReceived(MessageEvent<JavaScriptObject> messageEvent) {
        if (this.isRequestFromOriginAllowed(messageEvent.getOrigin())) {
            if (messageEvent.getData() instanceof JavaScriptObject) {
                JSONNull result;
                Request request = (Request)messageEvent.getData().cast();
                String operation = request.getOperation();
                StorageOperation op = StorageOperation.valueOf(operation);
                switch (op) {
                    case CLEAR: {
                        this.localStorage.clear();
                        result = JSONNull.getInstance();
                        break;
                    }
                    case GET_ITEM: {
                        String itemValue = this.localStorage.getItem(request.getKey());
                        result = this.jsonStringOrJsonNull(itemValue);
                        break;
                    }
                    case GET_LENGTH: {
                        result = new JSONNumber((double)this.localStorage.getLength());
                        break;
                    }
                    case KEY: {
                        String keyValue = this.localStorage.key(request.getIndex());
                        result = this.jsonStringOrJsonNull(keyValue);
                        break;
                    }
                    case REMOVE_ITEM: {
                        this.localStorage.removeItem(request.getKey());
                        result = JSONNull.getInstance();
                        break;
                    }
                    case SET_ITEM: {
                        this.localStorage.setItem(request.getKey(), request.getValue());
                        result = JSONNull.getInstance();
                        break;
                    }
                    case REGISTER_FOR_STORAGE_EVENTS: {
                        GWT.log((String)("received storage event handler registration from " + messageEvent.getOrigin()));
                        this.windowsToForwardStorageEventsToAndTheirTargetOrigins.add((Util.Pair<Object, String>)new Util.Pair((Object)messageEvent.getSource(), (Object)messageEvent.getOrigin()));
                        result = JSONNull.getInstance();
                        break;
                    }
                    case UNREGISTER_FOR_STORAGE_EVENTS: {
                        GWT.log((String)("received storage event handler unregistration from " + messageEvent.getOrigin()));
                        Iterator<Util.Pair<Object, String>> i = this.windowsToForwardStorageEventsToAndTheirTargetOrigins.iterator();
                        while (i.hasNext()) {
                            Util.Pair<Object, String> next = i.next();
                            if (next.getA() != messageEvent.getSource()) continue;
                            i.remove();
                        }
                        result = JSONNull.getInstance();
                        break;
                    }
                    case PING: {
                        result = new JSONString("PONG");
                        break;
                    }
                    default: {
                        throw new RuntimeException("Unknown operation " + (Object)((Object)op));
                    }
                }
                JSONObject response = new JSONObject();
                response.put("r", (JSONValue)result);
                response.put("id", (JSONValue)new JSONString(request.getId()));
                messageEvent.getSource().postMessage(response.getJavaScriptObject(), messageEvent.getOrigin());
            }
        } else {
            String messageRepresentation;
            if (messageEvent.getData() instanceof JavaScriptObject) {
                Request request = (Request)messageEvent.getData().cast();
                messageRepresentation = " with ID " + request.getId() + " and operation " + request.getOperation();
            } else {
                messageRepresentation = "";
            }
            GWT.log((String)("LocalStorageDrivenByMessageEvents dropped message" + messageRepresentation + " from inacceptable origin " + messageEvent.getOrigin()));
        }
    }

    private boolean isRequestFromOriginAllowed(String origin) {
        return this.acceptableCrossDomainStorageRequestOriginRegexp != null && origin.matches(this.acceptableCrossDomainStorageRequestOriginRegexp);
    }

    protected JSONValue jsonStringOrJsonNull(String s) {
        return s == null ? JSONNull.getInstance() : new JSONString(s);
    }

    private static JSONObject createEmptyRequest(UUID id) {
        JSONObject result = new JSONObject();
        result.put("id", (JSONValue)new JSONString(id.toString()));
        return result;
    }

    public static UUID getId(JavaScriptObjectWithID requestOrResponse) {
        return requestOrResponse.getId() == null ? null : UUID.fromString(requestOrResponse.getId());
    }

    private static JSONObject createOperationRequest(UUID id, StorageOperation operation) {
        JSONObject result = LocalStorageDrivenByMessageEvents.createEmptyRequest(id);
        result.put("o", (JSONValue)new JSONString(operation.name()));
        return result;
    }

    public static JSONObject createGetItemRequest(UUID id, String key) {
        JSONObject result = LocalStorageDrivenByMessageEvents.createOperationRequest(id, StorageOperation.GET_ITEM);
        result.put("k", (JSONValue)new JSONString(key));
        return result;
    }

    public static JSONObject createRemoveItemRequest(UUID id, String key) {
        JSONObject result = LocalStorageDrivenByMessageEvents.createOperationRequest(id, StorageOperation.REMOVE_ITEM);
        result.put("k", (JSONValue)new JSONString(key));
        return result;
    }

    public static JSONObject createGetLengthRequest(UUID id) {
        JSONObject result = LocalStorageDrivenByMessageEvents.createOperationRequest(id, StorageOperation.GET_LENGTH);
        return result;
    }

    public static JSONObject createKeyRequest(UUID id, int i) {
        JSONObject result = LocalStorageDrivenByMessageEvents.createOperationRequest(id, StorageOperation.KEY);
        result.put("i", (JSONValue)new JSONNumber((double)i));
        return result;
    }

    public static JSONObject createSetItemRequest(UUID id, String key, String value) {
        JSONObject result = LocalStorageDrivenByMessageEvents.createOperationRequest(id, StorageOperation.SET_ITEM);
        result.put("k", (JSONValue)new JSONString(key));
        result.put("v", (JSONValue)new JSONString(value));
        return result;
    }

    public static JSONObject createClearRequest(UUID id) {
        JSONObject result = LocalStorageDrivenByMessageEvents.createOperationRequest(id, StorageOperation.CLEAR);
        return result;
    }

    public static JSONObject createPingRequest(UUID id) {
        JSONObject result = LocalStorageDrivenByMessageEvents.createOperationRequest(id, StorageOperation.PING);
        return result;
    }

    public static JSONObject createRegisterStorageEventListener(UUID id) {
        JSONObject result = LocalStorageDrivenByMessageEvents.createOperationRequest(id, StorageOperation.REGISTER_FOR_STORAGE_EVENTS);
        return result;
    }

    public static JSONObject createUnregisterStorageEventListener(UUID id) {
        JSONObject result = LocalStorageDrivenByMessageEvents.createOperationRequest(id, StorageOperation.UNREGISTER_FOR_STORAGE_EVENTS);
        return result;
    }
}

