/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sse.gwt.client.shared.settings;

import com.sap.sse.common.settings.Settings;
import com.sap.sse.gwt.client.shared.components.ComponentLifecycle;
import com.sap.sse.gwt.client.shared.perspective.PerspectiveCompositeSettings;
import com.sap.sse.gwt.client.shared.perspective.PerspectiveLifecycle;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class ComponentUtils {
    public static <CS extends Settings> ComponentLifecycle<CS> determineLifecycle(Iterable<String> path, ComponentLifecycle<? extends Settings> current) {
        Iterator<String> pathIterator = path.iterator();
        while (current instanceof PerspectiveLifecycle && pathIterator.hasNext()) {
            String last = pathIterator.next();
            current = ((PerspectiveLifecycle)current).getLifecycleForId(last);
        }
        if (pathIterator.hasNext() || current == null) {
            throw new IllegalStateException("Settings path is not finished, but no perspective at current level");
        }
        return current;
    }

    public static <CS extends Settings> CS determineComponentSettingsFromPerspectiveSettings(Iterable<String> path, Settings current) {
        Iterator<String> pathIterator = path.iterator();
        while (current instanceof PerspectiveCompositeSettings && pathIterator.hasNext()) {
            String last = pathIterator.next();
            current = ((PerspectiveCompositeSettings)((Object)current)).findSettingsByComponentId(last);
        }
        if (pathIterator.hasNext() || current == null) {
            throw new IllegalStateException("Settings path is not finished, but no settings at current level");
        }
        return (CS)current;
    }

    public static <CS extends Settings> CS patchSettingsTree(List<String> path, Settings newSettings, CS settingsTree) {
        ArrayList<PerspectiveCompositeSettings> perspectiveSettingsPath = new ArrayList<PerspectiveCompositeSettings>();
        if (path.isEmpty() && !(settingsTree instanceof PerspectiveCompositeSettings)) {
            return (CS)newSettings;
        }
        if (!(settingsTree instanceof PerspectiveCompositeSettings)) {
            throw new IllegalStateException("Settings tree does not belong to a perspective, but due to a not empty path it has to");
        }
        Object current = settingsTree;
        PerspectiveCompositeSettings perspectiveSettings = (PerspectiveCompositeSettings)settingsTree;
        String childComponentId = null;
        while (current instanceof PerspectiveCompositeSettings && !path.isEmpty()) {
            childComponentId = path.remove(path.size() - 1);
            perspectiveSettings = (PerspectiveCompositeSettings)((Object)current);
            perspectiveSettingsPath.add(perspectiveSettings);
            current = perspectiveSettings.findSettingsByComponentId(childComponentId);
        }
        if (!path.isEmpty() || current == null) {
            throw new IllegalStateException("Settings path is not finished, but no settings at current level");
        }
        if (current instanceof PerspectiveCompositeSettings) {
            Object perspectiveOwnSettings = ((PerspectiveCompositeSettings)((Object)current)).getPerspectiveOwnSettings();
            newSettings = new PerspectiveCompositeSettings(perspectiveOwnSettings, perspectiveSettings.getSettingsPerComponentId());
        }
        while (!perspectiveSettingsPath.isEmpty()) {
            PerspectiveCompositeSettings parent = (PerspectiveCompositeSettings)((Object)perspectiveSettingsPath.remove(perspectiveSettingsPath.size() - 1));
            Map<String, Settings> originalSettingsPerComponent = parent.getSettingsPerComponentId();
            HashMap<String, Settings> newSettingsPerComponent = new HashMap<String, Settings>();
            for (Map.Entry<String, Settings> entry : originalSettingsPerComponent.entrySet()) {
                String componentId = entry.getKey();
                if (childComponentId.equals(componentId)) {
                    newSettingsPerComponent.put(childComponentId, (Settings)newSettings);
                    continue;
                }
                newSettingsPerComponent.put(componentId, entry.getValue());
            }
            newSettings = new PerspectiveCompositeSettings(parent.getPerspectiveOwnSettings(), newSettingsPerComponent);
        }
        return (CS)newSettings;
    }
}

