/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sse.gwt.client.shared.controls;

import com.google.gwt.animation.client.Animation;
import com.google.gwt.core.client.Scheduler;
import com.google.gwt.dom.client.Style;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.event.logical.shared.ResizeEvent;
import com.google.gwt.event.logical.shared.ResizeHandler;
import com.google.gwt.event.shared.HandlerRegistration;
import com.google.gwt.resources.client.ImageResource;
import com.google.gwt.user.client.Window;
import com.google.gwt.user.client.ui.FlowPanel;
import com.google.gwt.user.client.ui.HasVerticalAlignment;
import com.google.gwt.user.client.ui.Image;
import com.google.gwt.user.client.ui.LayoutPanel;
import com.google.gwt.user.client.ui.TabLayoutPanel;
import com.google.gwt.user.client.ui.VerticalPanel;
import com.google.gwt.user.client.ui.Widget;

public class ScrolledTabLayoutPanel
extends TabLayoutPanel {
    public static final String scrollLeftWidgetStyle = "gwt-ScrolledTabLayoutPanel-scrollLeft";
    public static final String scrollRightWidgetStyle = "gwt-ScrolledTabLayoutPanel-scrollRight";
    private static final int SCROLL_RIGHT_TAB_MARGIN = 10;
    private static final int SCROLL_ANIMATION_SPEED = 150;
    private LayoutPanel panel;
    private FlowPanel tabBar;
    private Widget scrollLeftWidget;
    private Widget scrollRightWidget;
    private HandlerRegistration windowResizeHandler;
    private boolean isScrolling = false;
    private final ImageResource leftArrowImage;
    private final ImageResource rightArrowImage;
    private final int scrollSpeed;
    private final double barHeight;
    private final Style.Unit barUnit;

    public ScrolledTabLayoutPanel(double barHeight, Style.Unit barUnit, ImageResource leftArrowImage, ImageResource rightArrowImage) {
        this(barHeight, barUnit, leftArrowImage, rightArrowImage, 100);
    }

    public ScrolledTabLayoutPanel(double barHeight, Style.Unit barUnit, ImageResource leftArrowImage, ImageResource rightArrowImage, int scrollSpeed) {
        super(barHeight, barUnit);
        this.leftArrowImage = leftArrowImage;
        this.rightArrowImage = rightArrowImage;
        this.scrollSpeed = scrollSpeed;
        this.barHeight = barHeight;
        this.barUnit = barUnit;
        this.panel = (LayoutPanel)this.getWidget();
        int i = 0;
        while (i < this.panel.getWidgetCount()) {
            Widget widget = this.panel.getWidget(i);
            if (widget instanceof FlowPanel) {
                this.tabBar = (FlowPanel)widget;
                break;
            }
            ++i;
        }
        this.initScrollButtons();
    }

    public void add(Widget child, Widget tab) {
        super.add(child, tab);
        this.checkIfScrollButtonsNecessary();
    }

    public boolean remove(Widget w) {
        boolean b = super.remove(w);
        this.checkIfScrollButtonsNecessary();
        return b;
    }

    protected void onLoad() {
        super.onLoad();
        if (this.windowResizeHandler == null) {
            this.windowResizeHandler = Window.addResizeHandler((ResizeHandler)new ResizeHandler(){

                public void onResize(ResizeEvent event) {
                    ScrolledTabLayoutPanel.this.checkIfScrollButtonsNecessary();
                }
            });
        }
        this.checkIfScrollButtonsNecessary();
    }

    protected void onUnload() {
        super.onUnload();
        if (this.windowResizeHandler != null) {
            this.windowResizeHandler.removeHandler();
            this.windowResizeHandler = null;
        }
    }

    private ClickHandler createScrollClickHandler(final int diff) {
        return new ClickHandler(){

            public void onClick(ClickEvent event) {
                if (ScrolledTabLayoutPanel.this.isScrolling) {
                    return;
                }
                int difference = diff;
                Widget lastTab = ScrolledTabLayoutPanel.this.getLastTab();
                if (lastTab == null) {
                    return;
                }
                int oldLeft = ScrolledTabLayoutPanel.parsePosition(ScrolledTabLayoutPanel.this.tabBar.getElement().getStyle().getLeft());
                if (ScrolledTabLayoutPanel.this.getAbsoluteRightOfTabBar() < ScrolledTabLayoutPanel.this.getAbsoluteRightOfWidget(lastTab)) {
                    difference = Math.max(difference, ScrolledTabLayoutPanel.this.getAbsoluteRightOfTabBar() - ScrolledTabLayoutPanel.this.getAbsoluteRightOfWidget(lastTab) - 10);
                }
                int newLeft = Math.min(oldLeft + difference, 0);
                ScrolledTabLayoutPanel.this.scrollTo(oldLeft, newLeft);
            }
        };
    }

    private void initScrollButtons() {
        Image scrollLeftButton = new Image(this.leftArrowImage);
        this.scrollLeftWidget = this.centerVertical((Widget)scrollLeftButton, scrollLeftWidgetStyle);
        this.panel.insert(this.scrollLeftWidget, 0);
        this.panel.setWidgetLeftWidth(this.scrollLeftWidget, 0.0, Style.Unit.PX, (double)scrollLeftButton.getWidth(), Style.Unit.PX);
        this.panel.setWidgetTopHeight(this.scrollLeftWidget, 0.0, Style.Unit.PX, this.barHeight, this.barUnit);
        scrollLeftButton.addClickHandler(this.createScrollClickHandler(this.scrollSpeed));
        this.scrollLeftWidget.setVisible(false);
        Image scrollRightButton = new Image(this.rightArrowImage);
        this.scrollRightWidget = this.centerVertical((Widget)scrollRightButton, scrollRightWidgetStyle);
        this.panel.insert(this.scrollRightWidget, 0);
        this.panel.setWidgetRightWidth(this.scrollRightWidget, 0.0, Style.Unit.PX, (double)scrollRightButton.getWidth(), Style.Unit.PX);
        this.panel.setWidgetTopHeight(this.scrollRightWidget, 0.0, Style.Unit.PX, this.barHeight, this.barUnit);
        scrollRightButton.addClickHandler(this.createScrollClickHandler(-this.scrollSpeed));
        this.scrollRightWidget.setVisible(false);
    }

    private Widget centerVertical(Widget widget, String styleName) {
        VerticalPanel vPanel = new VerticalPanel();
        vPanel.setSize("100%", "100%");
        vPanel.setStylePrimaryName(styleName);
        vPanel.setVerticalAlignment(HasVerticalAlignment.ALIGN_MIDDLE);
        vPanel.getElement().getStyle().setBackgroundColor("#ccc");
        vPanel.getElement().getStyle().setMarginTop(6.0, Style.Unit.PX);
        vPanel.add(widget);
        return vPanel;
    }

    public void checkIfScrollButtonsNecessary() {
        Scheduler.get().scheduleDeferred(new Scheduler.ScheduledCommand(){

            public void execute() {
                boolean needsScrollingToRight = ScrolledTabLayoutPanel.this.isScrollingToRightNecessary();
                boolean needsScrollingToLeft = ScrolledTabLayoutPanel.this.isScrollingToLeftNecessary();
                if (ScrolledTabLayoutPanel.this.scrollRightWidget.isVisible() && !needsScrollingToLeft && !needsScrollingToRight) {
                    ScrolledTabLayoutPanel.this.resetScrollPosition();
                }
                ScrolledTabLayoutPanel.this.scrollLeftWidget.setVisible(needsScrollingToLeft);
                ScrolledTabLayoutPanel.this.scrollRightWidget.setVisible(needsScrollingToRight);
            }
        });
    }

    public void scrollToTab(int tabNumber) {
        Widget tab = this.getTab(tabNumber);
        if (tab == null || !this.isScrollingNecessary()) {
            return;
        }
        int oldLeft = ScrolledTabLayoutPanel.parsePosition(this.tabBar.getElement().getStyle().getLeft());
        int difference = this.getAbsoluteRightOfTabBar() - this.getAbsoluteRightOfWidget(tab) - 10;
        int newLeft = Math.min(oldLeft + difference, 0);
        this.scrollTo(oldLeft, newLeft);
    }

    private void resetScrollPosition() {
        this.scrollTo(0, 0);
    }

    private void scrollTo(final int oldPos, int newPos) {
        if (this.isScrolling) {
            return;
        }
        this.isScrolling = true;
        final int difference = newPos - oldPos;
        new Animation(){

            protected void onUpdate(double progress) {
                ScrolledTabLayoutPanel.this.tabBar.getElement().getStyle().setLeft((double)oldPos + this.interpolate(progress) * (double)difference, Style.Unit.PX);
            }

            protected void onComplete() {
                super.onComplete();
                ScrolledTabLayoutPanel.this.checkIfScrollButtonsNecessary();
                ScrolledTabLayoutPanel.this.isScrolling = false;
            }
        }.run(150);
    }

    private boolean isScrollingNecessary() {
        return this.isScrollingToLeftNecessary() || this.isScrollingToRightNecessary();
    }

    private boolean isScrollingToRightNecessary() {
        Widget lastTab = this.getLastTab();
        if (lastTab == null) {
            return false;
        }
        return this.getAbsoluteRightOfWidget(lastTab) > this.getAbsoluteRightOfTabBar();
    }

    private boolean isScrollingToLeftNecessary() {
        Widget firstTab = this.getFirstTab();
        if (firstTab == null) {
            return false;
        }
        return this.getAbsoluteLeftOfWidget(firstTab) < this.getAbsoluteLeftOfTabBar();
    }

    private int getAbsoluteLeftOfTabBar() {
        return this.tabBar.getElement().getParentElement().getAbsoluteLeft();
    }

    private int getAbsoluteRightOfTabBar() {
        return this.tabBar.getElement().getParentElement().getAbsoluteRight();
    }

    private int getAbsoluteLeftOfWidget(Widget widget) {
        return widget.getElement().getAbsoluteLeft();
    }

    private int getAbsoluteRightOfWidget(Widget widget) {
        return widget.getElement().getAbsoluteRight();
    }

    private Widget getLastTab() {
        if (this.tabBar.getWidgetCount() == 0) {
            return null;
        }
        return this.tabBar.getWidget(this.tabBar.getWidgetCount() - 1);
    }

    private Widget getTab(int tabNumber) {
        if (tabNumber < 0 || tabNumber >= this.tabBar.getWidgetCount()) {
            return null;
        }
        return this.tabBar.getWidget(tabNumber);
    }

    private Widget getFirstTab() {
        if (this.tabBar.getWidgetCount() == 0) {
            return null;
        }
        return this.tabBar.getWidget(0);
    }

    private static int parsePosition(String positionString) {
        int position;
        try {
            int i = 0;
            while (i < positionString.length()) {
                char c = positionString.charAt(i);
                if (c != '-' && (c < '0' || c > '9')) {
                    positionString = positionString.substring(0, i);
                }
                ++i;
            }
            position = Integer.parseInt(positionString);
        }
        catch (NumberFormatException ex) {
            position = 0;
        }
        return position;
    }
}

