/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sse.gwt.client.shared.components;

import com.google.gwt.http.client.UrlBuilder;
import com.sap.sse.common.settings.Settings;
import com.sap.sse.common.settings.generic.GenericSerializableSettings;
import com.sap.sse.common.settings.generic.SettingsMap;
import com.sap.sse.common.settings.generic.support.SettingsUtil;
import com.sap.sse.gwt.settings.SettingsToUrlSerializer;
import com.sap.sse.gwt.settings.UrlBuilderUtil;
import java.util.function.Supplier;

public class LinkWithSettingsGenerator<S extends Settings> {
    private final SettingsToUrlSerializer settingsToUrlSerializer = new SettingsToUrlSerializer();
    private final String baseUrl;
    private final String path;
    private final GenericSerializableSettings[] contextDefinition;
    private final Supplier<S> settingsWithDefaultsFactory;

    public LinkWithSettingsGenerator(GenericSerializableSettings ... contextDefinition) {
        this((String)null, contextDefinition);
    }

    public LinkWithSettingsGenerator(String path, GenericSerializableSettings ... contextDefinition) {
        this(null, path, contextDefinition);
    }

    public LinkWithSettingsGenerator(String path, Supplier<S> settingsWithDefaultsFactory, GenericSerializableSettings ... contextDefinition) {
        this(null, path, settingsWithDefaultsFactory, contextDefinition);
    }

    public LinkWithSettingsGenerator(String baseUrl, String path, GenericSerializableSettings ... contextDefinition) {
        this(baseUrl, path, (Supplier<S>)null, contextDefinition);
    }

    public LinkWithSettingsGenerator(String baseUrl, String path, Supplier<S> settingsWithDefaultsFactory, GenericSerializableSettings ... contextDefinition) {
        this.baseUrl = baseUrl;
        this.path = path;
        this.settingsWithDefaultsFactory = settingsWithDefaultsFactory;
        this.contextDefinition = contextDefinition;
    }

    public String createUrl() {
        return this.createUrl(null);
    }

    public String createUrl(S settings) {
        Object settingsToSerialize;
        UrlBuilder urlBuilder = this.baseUrl != null && this.path != null ? UrlBuilderUtil.createUrlBuilderFromBaseURLAndPathWithCleanParameters(this.baseUrl, this.path) : (this.path != null ? UrlBuilderUtil.createUrlBuilderFromCurrentLocationWithCleanParametersAndPath(this.path) : UrlBuilderUtil.createUrlBuilderFromCurrentLocationWithCleanParameters());
        if (this.settingsWithDefaultsFactory == null) {
            settingsToSerialize = settings;
        } else {
            settingsToSerialize = (Settings)this.settingsWithDefaultsFactory.get();
            SettingsUtil.copyValues(settings, settingsToSerialize);
        }
        this.serializeSettingsToUrlBuilder(urlBuilder, settingsToSerialize, this.contextDefinition);
        return urlBuilder.buildString();
    }

    protected void serializeSettingsToUrlBuilder(UrlBuilder urlBuilder, S settings, GenericSerializableSettings ... contextDefinition) {
        GenericSerializableSettings[] genericSerializableSettingsArray = contextDefinition;
        int n = contextDefinition.length;
        int n2 = 0;
        while (n2 < n) {
            GenericSerializableSettings contextDefinitionItem = genericSerializableSettingsArray[n2];
            this.settingsToUrlSerializer.serializeToUrlBuilder(contextDefinitionItem, urlBuilder);
            ++n2;
        }
        if (settings instanceof SettingsMap) {
            this.settingsToUrlSerializer.serializeSettingsMapToUrlBuilder((SettingsMap)settings, urlBuilder);
        } else if (settings instanceof GenericSerializableSettings) {
            this.settingsToUrlSerializer.serializeToUrlBuilder((GenericSerializableSettings)settings, urlBuilder);
        }
    }
}

