/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sse.gwt.client.shared.components;

import com.sap.sse.common.settings.Settings;
import com.sap.sse.gwt.client.dialog.DataEntryDialog;
import com.sap.sse.gwt.client.shared.components.Component;
import com.sap.sse.gwt.client.shared.components.CompositeSettings;
import com.sap.sse.gwt.client.shared.components.CompositeTabbedSettingsDialogComponent;
import com.sap.sse.gwt.client.shared.components.SettingsDialogComponent;
import java.util.HashMap;
import java.util.Map;

public class CompositeValidator
implements DataEntryDialog.Validator<CompositeSettings> {
    private final Map<String, DataEntryDialog.Validator<?>> validatorsMappedByComponent = new HashMap();

    public CompositeValidator(Iterable<CompositeTabbedSettingsDialogComponent.ComponentAndDialogComponent<?>> componentsAndDialogComponents) {
        for (CompositeTabbedSettingsDialogComponent.ComponentAndDialogComponent<?> component : componentsAndDialogComponents) {
            this.validatorsMappedByComponent.put(((Component)component.getA()).getId(), ((SettingsDialogComponent)component.getB()).getValidator());
        }
    }

    @Override
    public String getErrorMessage(CompositeSettings valueToValidate) {
        StringBuilder result = new StringBuilder();
        for (Map.Entry<String, Settings> componentAndSettings : valueToValidate.getSettingsPerComponentId().entrySet()) {
            String errorMessage = this.getErrorMessage(componentAndSettings);
            if (errorMessage == null || errorMessage.isEmpty()) continue;
            result.append(errorMessage);
        }
        return result.toString();
    }

    @Override
    private <SettingsType extends Settings> String getErrorMessage(Map.Entry<String, SettingsType> componentIdAndSettings) {
        String errorMessage = null;
        DataEntryDialog.Validator<?> validator = this.validatorsMappedByComponent.get(componentIdAndSettings.getKey());
        if (validator != null && (errorMessage = validator.getErrorMessage((Settings)componentIdAndSettings.getValue())) != null && !errorMessage.isEmpty() && !this.getClass().equals(validator.getClass())) {
            errorMessage = String.valueOf(errorMessage) + "; ";
        }
        return errorMessage;
    }
}

