/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sse.gwt.client.shared.components;

import com.google.gwt.user.client.ui.FocusWidget;
import com.google.gwt.user.client.ui.TabPanel;
import com.google.gwt.user.client.ui.Widget;
import com.sap.sse.common.Util;
import com.sap.sse.common.settings.Settings;
import com.sap.sse.gwt.client.dialog.DataEntryDialog;
import com.sap.sse.gwt.client.shared.components.Component;
import com.sap.sse.gwt.client.shared.components.CompositeSettings;
import com.sap.sse.gwt.client.shared.components.CompositeValidator;
import com.sap.sse.gwt.client.shared.components.SettingsDialogComponent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;

public class CompositeTabbedSettingsDialogComponent
implements SettingsDialogComponent<CompositeSettings> {
    private final Collection<ComponentAndDialogComponent<?>> components = new ArrayList();

    public CompositeTabbedSettingsDialogComponent(Iterable<Component<?>> components) {
        for (Component<?> component : components) {
            if (!component.hasSettings()) continue;
            this.components.add(this.createComponentAndDialogComponent(component));
        }
    }

    private <SettingsType extends Settings> ComponentAndDialogComponent<SettingsType> createComponentAndDialogComponent(Component<SettingsType> component) {
        return new ComponentAndDialogComponent<SettingsType>(component, component.getSettingsDialogComponent(component.getSettings()));
    }

    @Override
    public Widget getAdditionalWidget(DataEntryDialog<?> dialog) {
        TabPanel result = new TabPanel();
        for (ComponentAndDialogComponent<?> component : this.components) {
            Widget w = ((SettingsDialogComponent)component.getB()).getAdditionalWidget(dialog);
            result.add(w, ((Component)component.getA()).getLocalizedShortName());
        }
        result.selectTab(0);
        return result;
    }

    @Override
    public CompositeSettings getResult() {
        HashMap<String, Settings> settings = new HashMap<String, Settings>();
        for (ComponentAndDialogComponent<?> component : this.components) {
            settings.put(((Component)component.getA()).getId(), (Settings)((SettingsDialogComponent)component.getB()).getResult());
        }
        return new CompositeSettings(settings);
    }

    @Override
    public DataEntryDialog.Validator<CompositeSettings> getValidator() {
        return new CompositeValidator(this.components);
    }

    @Override
    public FocusWidget getFocusWidget() {
        for (ComponentAndDialogComponent<?> component : this.components) {
            FocusWidget fw = ((SettingsDialogComponent)component.getB()).getFocusWidget();
            if (fw == null) continue;
            return fw;
        }
        return null;
    }

    public class ComponentAndDialogComponent<SettingsType extends Settings>
    extends Util.Pair<Component<SettingsType>, SettingsDialogComponent<SettingsType>> {
        private static final long serialVersionUID = -4342002423677523158L;

        public ComponentAndDialogComponent(Component<SettingsType> a, SettingsDialogComponent<SettingsType> b) {
            super(a, b);
        }
    }
}

