/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sse.gwt.client.player;

import com.sap.sse.common.Util;
import com.sap.sse.gwt.client.player.TimeRangeChangeListener;
import com.sap.sse.gwt.client.player.TimeRangeProvider;
import java.util.Arrays;
import java.util.Date;
import java.util.HashSet;
import java.util.Set;

public class TimeRangeModel
implements TimeRangeProvider {
    protected Date fromTime;
    protected Date toTime;
    protected final Set<TimeRangeChangeListener> listeners = new HashSet<TimeRangeChangeListener>();

    @Override
    public void addTimeRangeChangeListener(TimeRangeChangeListener listener) {
        this.listeners.add(listener);
    }

    @Override
    public void removeTimeRangeChangeListener(TimeRangeChangeListener listener) {
        this.listeners.remove(listener);
    }

    @Override
    public void setTimeRange(Date fromTime, Date toTime, TimeRangeChangeListener ... listenersNotToNotify) {
        boolean toChanged;
        boolean fromChanged = !Util.equalsWithNull((Object)this.fromTime, (Object)fromTime);
        boolean bl = toChanged = !Util.equalsWithNull((Object)this.toTime, (Object)toTime);
        if (fromChanged) {
            Date date = this.fromTime = fromTime != null ? new Date(fromTime.getTime()) : null;
        }
        if (toChanged) {
            Date date = this.toTime = toTime != null ? new Date(toTime.getTime()) : null;
        }
        if (fromChanged || toChanged) {
            for (TimeRangeChangeListener listener : this.listeners) {
                if (listenersNotToNotify != null && Arrays.asList(listenersNotToNotify).contains(listener)) continue;
                listener.onTimeRangeChanged(fromTime, toTime);
            }
        }
    }

    @Override
    public Util.Pair<Date, Date> getTimeRange() {
        return new Util.Pair((Object)this.fromTime, (Object)this.toTime);
    }

    @Override
    public Date getFromTime() {
        return this.fromTime;
    }

    @Override
    public Date getToTime() {
        return this.toTime;
    }

    public String toString() {
        return "TimeRangeModel [fromTime=" + this.fromTime + ", toTime=" + this.toTime + "]";
    }
}

