/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sse.gwt.client.panels;

import com.google.gwt.animation.client.Animation;
import com.google.gwt.core.client.GWT;
import com.google.gwt.core.client.JavaScriptObject;
import com.google.gwt.core.client.Scheduler;
import com.google.gwt.dom.client.DivElement;
import com.google.gwt.dom.client.Element;
import com.google.gwt.dom.client.Node;
import com.google.gwt.dom.client.Style;
import com.google.gwt.event.dom.client.ScrollEvent;
import com.google.gwt.event.dom.client.ScrollHandler;
import com.google.gwt.event.logical.shared.ResizeEvent;
import com.google.gwt.event.logical.shared.ResizeHandler;
import com.google.gwt.event.shared.HandlerRegistration;
import com.google.gwt.uibinder.client.UiBinder;
import com.google.gwt.uibinder.client.UiField;
import com.google.gwt.user.client.Command;
import com.google.gwt.user.client.DOM;
import com.google.gwt.user.client.Event;
import com.google.gwt.user.client.EventListener;
import com.google.gwt.user.client.Window;
import com.google.gwt.user.client.ui.RootPanel;
import com.google.gwt.user.client.ui.ScrollPanel;
import com.google.gwt.user.client.ui.Widget;
import java.util.ArrayList;
import java.util.List;

public class OverlayAssistantScrollPanel
extends ScrollPanel {
    private static MyUiBinder uiBinder = (MyUiBinder)GWT.create(MyUiBinder.class);
    private final DivElement overlayWidget;
    @UiField
    protected DivElement overlayScrollPanelUi;
    @UiField
    protected DivElement overlayDummyContentUi;
    private final OverlayAnimation animation = new OverlayAnimation();
    private final List<HandlerRegistration> registrations = new ArrayList<HandlerRegistration>();
    private final Element contentToSyncWith;
    private final boolean hasMutationObservationCapability;
    private JavaScriptObject observer;
    private boolean ignoreOverlayScrollEvent = false;
    private boolean ignoreTableScrollEvent = false;

    public OverlayAssistantScrollPanel(Widget contentToScroll) {
        super(contentToScroll);
        this.getElement().getStyle().setPaddingBottom(25.0, Style.Unit.PX);
        this.contentToSyncWith = contentToScroll.getElement();
        this.hasMutationObservationCapability = this.hasMutationObservationCapability();
        this.overlayWidget = (DivElement)uiBinder.createAndBindUi((Object)this);
    }

    protected void onLoad() {
        RootPanel.get().getElement().appendChild((Node)this.overlayWidget);
        if (!this.hasMutationObservationCapability) {
            return;
        }
        Scheduler.get().scheduleDeferred(new Scheduler.ScheduledCommand(){

            public void execute() {
                OverlayAssistantScrollPanel.this.matchScrollpanelAndContentWidths();
                OverlayAssistantScrollPanel.this.updateOverlayDisplay();
                OverlayAssistantScrollPanel.this.applyScrollpanelToOverlay();
            }
        });
        this.registrations.add(Window.addResizeHandler((ResizeHandler)new ResizeHandler(){

            public void onResize(ResizeEvent event) {
                OverlayAssistantScrollPanel.this.matchScrollpanelAndContentWidths();
                OverlayAssistantScrollPanel.this.updateOverlayDisplay();
                OverlayAssistantScrollPanel.this.applyScrollpanelToOverlay();
            }
        }));
        this.registrations.add(Window.addWindowScrollHandler((Window.ScrollHandler)new Window.ScrollHandler(){

            public void onWindowScroll(Window.ScrollEvent event) {
                OverlayAssistantScrollPanel.this.matchScrollpanelAndContentWidths();
                OverlayAssistantScrollPanel.this.updateOverlayDisplay();
            }
        }));
        this.registrations.add(this.addScrollHandler(new ScrollHandler(){

            public void onScroll(ScrollEvent event) {
                if (OverlayAssistantScrollPanel.this.ignoreTableScrollEvent) {
                    OverlayAssistantScrollPanel.this.ignoreTableScrollEvent = false;
                } else {
                    OverlayAssistantScrollPanel.this.ignoreOverlayScrollEvent = true;
                    OverlayAssistantScrollPanel.this.applyScrollpanelToOverlay();
                }
            }
        }));
        this.createObserverForCurrentChild();
        DOM.sinkEvents((Element)this.overlayScrollPanelUi, (int)16384);
        DOM.setEventListener((Element)this.overlayScrollPanelUi, (EventListener)new EventListener(){

            public void onBrowserEvent(Event event) {
                if (OverlayAssistantScrollPanel.this.ignoreOverlayScrollEvent) {
                    OverlayAssistantScrollPanel.this.ignoreOverlayScrollEvent = false;
                } else if (event.getTypeInt() == 16384) {
                    OverlayAssistantScrollPanel.this.ignoreTableScrollEvent = true;
                    OverlayAssistantScrollPanel.this.applyOverlayToScrollpanel();
                }
            }
        });
    }

    private void applyScrollpanelToOverlay() {
        this.syncScrollers((Element)this.getElement(), (Element)this.overlayScrollPanelUi);
        this.matchScrollpanelAndContentWidths();
    }

    private void applyOverlayToScrollpanel() {
        this.syncScrollers((Element)this.overlayScrollPanelUi, (Element)this.getElement());
        this.matchScrollpanelAndContentWidths();
    }

    protected void onUnload() {
        super.onUnload();
        if (!this.hasMutationObservationCapability) {
            return;
        }
        this.animation.detach();
        for (HandlerRegistration handlerRegistration : this.registrations) {
            handlerRegistration.removeHandler();
        }
        if (this.observer != null) {
            this.removeObserverFromCurrentChildWidget();
        }
        this.overlayWidget.removeFromParent();
    }

    public void setWidget(Widget w) {
        if (this.observer != null) {
            this.removeObserverFromCurrentChildWidget();
        }
        super.setWidget(w);
        if (this.isAttached()) {
            this.createObserverForCurrentChild();
        }
    }

    private void createObserverForCurrentChild() {
        this.observer = this.setupObserver(this.contentToSyncWith, new Command(){

            public void execute() {
                OverlayAssistantScrollPanel.this.matchScrollpanelAndContentWidths();
                OverlayAssistantScrollPanel.this.updateOverlayDisplay();
                OverlayAssistantScrollPanel.this.applyScrollpanelToOverlay();
            }
        });
    }

    private void removeObserverFromCurrentChildWidget() {
        this.disconnectObserver();
        this.observer = null;
    }

    private void syncScrollers(Element source, Element target) {
        target.setScrollLeft(source.getScrollLeft());
    }

    private void matchScrollpanelAndContentWidths() {
        this.overlayDummyContentUi.getStyle().setWidth((double)this.contentToSyncWith.getClientWidth(), Style.Unit.PX);
        this.overlayScrollPanelUi.getStyle().setWidth((double)this.getOffsetWidth(), Style.Unit.PX);
        this.overlayScrollPanelUi.getStyle().setMarginLeft((double)this.getAbsoluteLeft(), Style.Unit.PX);
    }

    private void updateOverlayDisplay() {
        int docViewTop = Window.getScrollTop();
        int docViewBottom = docViewTop + Window.getClientHeight();
        int elemTop = this.getAbsoluteTop();
        int elemBottom = elemTop + this.getOffsetHeight() + 15;
        boolean scrollbarIsShown = this.isElementHorizontalScrollShown();
        boolean syncedScrollbarIsVisible = elemBottom <= docViewBottom;
        boolean scrollPanelEntirelyOutOfView = elemTop + 40 > this.overlayWidget.getAbsoluteTop();
        this.animation.updateOverlayToState(scrollbarIsShown && !syncedScrollbarIsVisible && !scrollPanelEntirelyOutOfView);
    }

    public boolean isElementHorizontalScrollShown() {
        return this.contentToSyncWith.getClientWidth() > this.getElement().getClientWidth();
    }

    private native JavaScriptObject setupObserver(Element var1, Command var2);

    private native void disconnectObserver();

    private native boolean hasMutationObservationCapability();

    static interface MyUiBinder
    extends UiBinder<DivElement, OverlayAssistantScrollPanel> {
    }

    private final class OverlayAnimation
    extends Animation {
        private boolean overlayToolbarIsCurrentlyVisible = false;
        private boolean overlayRequestedTargetState;

        private OverlayAnimation() {
        }

        public void updateOverlayToState(boolean doShowOverlay) {
            this.animate(doShowOverlay, 200);
        }

        public void detach() {
            this.overlayToolbarIsCurrentlyVisible = false;
        }

        public void animate(boolean requestedVisibleState, int duration) {
            boolean changed = this.overlayToolbarIsCurrentlyVisible ^ requestedVisibleState;
            if (!changed) {
                return;
            }
            this.overlayRequestedTargetState = requestedVisibleState;
            this.run(duration);
        }

        protected void onStart() {
            OverlayAssistantScrollPanel.this.overlayWidget.getStyle().setOpacity((double)(!this.overlayRequestedTargetState ? 1 : 0));
        }

        protected void onUpdate(double progress) {
            OverlayAssistantScrollPanel.this.overlayWidget.getStyle().setOpacity(this.overlayRequestedTargetState ? progress : 1.0 - progress);
        }

        protected void onComplete() {
            this.overlayToolbarIsCurrentlyVisible = this.overlayRequestedTargetState;
            OverlayAssistantScrollPanel.this.overlayWidget.getStyle().setOpacity((double)(this.overlayRequestedTargetState ? 1 : 0));
        }

        protected void onCancel() {
            this.onComplete();
        }
    }
}

