/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sse.gwt.client.formfactor;

import com.google.gwt.dom.client.Document;
import com.google.gwt.dom.client.MetaElement;
import com.google.gwt.dom.client.Node;
import com.sap.sse.common.Util;

public abstract class MetaTagUtil {
    private static final String TAG_NAME_VIEWPORT = "viewport";
    private static final String CONTENT_SEPARATOR = ",";
    private static final String CONTENT_PROPERTY_VALUE_SEPARATOR = "=";
    private static final String CONTENT_PROPERTY_WIDTH = "width";
    private static final String CONTENT_PROPERTY_INITIAL_SCALE = "initial-scale";
    private static final String CONTENT_PROPERTY_MAXIMUM_SCALE = "maximum-scale";
    public static final String WIDTH_VALUE_DEVICE_WIDTH = "device-width";
    public static final String SCALE_VALUE_SMALL = "0.5";
    public static final String SCALE_VALUE_SMALLER = "0.75";
    public static final String SCALE_VALUE_NORMAL = "1";
    public static final String SCALE_VALUE_LARGE = "2";

    public static void setViewportToDeviceWidth(String initialScaleValue, String maximumScaleValue) {
        MetaTagUtil.setViewport(WIDTH_VALUE_DEVICE_WIDTH, initialScaleValue, maximumScaleValue);
    }

    public static void setViewport(String widthValue, String initialScaleValue, String maximumScaleValue) {
        String width = MetaTagUtil.content(CONTENT_PROPERTY_WIDTH, widthValue);
        String initialScale = MetaTagUtil.content(CONTENT_PROPERTY_INITIAL_SCALE, initialScaleValue);
        String maximumScale = MetaTagUtil.content(CONTENT_PROPERTY_MAXIMUM_SCALE, maximumScaleValue);
        MetaTagUtil.appendMetaElement(TAG_NAME_VIEWPORT, Util.join((String)CONTENT_SEPARATOR, (String[])new String[]{width, initialScale, maximumScale}));
    }

    private static String content(String property, String value) {
        return String.valueOf(property) + CONTENT_PROPERTY_VALUE_SEPARATOR + value;
    }

    private static void appendMetaElement(String name, String content) {
        MetaElement metaElement = Document.get().createMetaElement();
        metaElement.setName(name);
        metaElement.setContent(content);
        Document.get().getHead().appendChild((Node)metaElement);
    }
}

