/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sse.gwt.client.dialog;

import com.google.gwt.core.client.GWT;
import com.google.gwt.dom.client.Element;
import com.google.gwt.dom.client.NativeEvent;
import com.google.gwt.dom.client.Node;
import com.google.gwt.dom.client.Style;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.event.dom.client.DomEvent;
import com.google.gwt.event.dom.client.MouseDownEvent;
import com.google.gwt.event.dom.client.MouseMoveEvent;
import com.google.gwt.event.dom.client.MouseUpEvent;
import com.google.gwt.event.shared.HasHandlers;
import com.google.gwt.resources.client.ClientBundle;
import com.google.gwt.resources.client.CssResource;
import com.google.gwt.user.client.DOM;
import com.google.gwt.user.client.Event;
import com.google.gwt.user.client.ui.Anchor;
import com.google.gwt.user.client.ui.DialogBox;
import com.google.gwt.user.client.ui.FlowPanel;
import com.google.gwt.user.client.ui.Grid;
import com.google.gwt.user.client.ui.PopupPanel;
import com.google.gwt.user.client.ui.RootPanel;
import com.google.gwt.user.client.ui.Widget;

public class WindowBox
extends DialogBox {
    private static final int MIN_WIDTH = 50;
    private static final int MIN_HEIGHT = 50;
    private FlowPanel container;
    private FlowPanel controlsPanel;
    private Anchor close;
    private Anchor minimize;
    private int dragX;
    private int dragY;
    private int minWidth = 50;
    private int minHeight = 50;
    private DragMode dragMode;
    private PopoutHandler popoutHandler;
    private FlowPanel blocker;
    private Grid ctrlGrid;

    public void setMinHeight(int minHeight) {
        this.minHeight = minHeight;
    }

    public void setMinWidth(int minWidth) {
        this.minWidth = minWidth;
    }

    protected void updateCursor(DragMode dragMode, Element element) {
        Style.Cursor cursor;
        if (dragMode != null) {
            switch (dragMode) {
                case MOVE: {
                    cursor = Style.Cursor.MOVE;
                    break;
                }
                case NORTH_WEST_RESIZE: {
                    cursor = Style.Cursor.NW_RESIZE;
                    break;
                }
                case NORTH_RESIZE: {
                    cursor = Style.Cursor.N_RESIZE;
                    break;
                }
                case NORTH_EAST_RESIZE: {
                    cursor = Style.Cursor.NE_RESIZE;
                    break;
                }
                case WEST_RESIZE: {
                    cursor = Style.Cursor.W_RESIZE;
                    break;
                }
                case EAST_RESIZE: {
                    cursor = Style.Cursor.E_RESIZE;
                    break;
                }
                case SOUTH_WEST_RESIZE: {
                    cursor = Style.Cursor.SW_RESIZE;
                    break;
                }
                case SOUTH_RESIZE: {
                    cursor = Style.Cursor.S_RESIZE;
                    break;
                }
                case SOUTH_EAST_RESIZE: {
                    cursor = Style.Cursor.SE_RESIZE;
                    break;
                }
                default: {
                    cursor = Style.Cursor.AUTO;
                    break;
                }
            }
        } else {
            cursor = Style.Cursor.AUTO;
        }
        element.getStyle().setCursor(cursor);
    }

    public WindowBox(String title, String titleTooltip, Widget content, PopoutHandler popoutHandler) {
        super(false, false);
        WindowBoxResources.INSTANCE.windowBoxCss().ensureInjected();
        this.popoutHandler = popoutHandler;
        this.setStyleName("gwt-extras-WindowBox", true);
        this.container = new FlowPanel();
        super.setWidget((Widget)this.container);
        this.close = new Anchor();
        this.close.setStyleName("gwt-extras-dialog-close");
        this.close.addClickHandler(new ClickHandler(){

            public void onClick(ClickEvent event) {
                WindowBox.this.onCloseClick(event);
            }
        });
        this.minimize = new Anchor();
        this.minimize.setStyleName("gwt-extras-dialog-minimize");
        this.minimize.addClickHandler(new ClickHandler(){

            public void onClick(ClickEvent event) {
                WindowBox.this.onPopoutClick(event);
            }
        });
        this.ctrlGrid = null;
        if (popoutHandler != null) {
            this.ctrlGrid = new Grid(1, 3);
            this.ctrlGrid.setWidget(0, 1, (Widget)this.minimize);
            this.ctrlGrid.setWidget(0, 2, (Widget)this.close);
        } else {
            this.ctrlGrid = new Grid(1, 2);
            this.ctrlGrid.setWidget(0, 1, (Widget)this.close);
        }
        this.controlsPanel = new FlowPanel();
        this.controlsPanel.setStyleName("gwt-extras-dialog-controls");
        this.controlsPanel.add((Widget)this.ctrlGrid);
        this.container.add((Widget)this.controlsPanel);
        this.setTitle(titleTooltip);
        this.setText(title);
        this.setWidget(content);
        this.blocker = new FlowPanel();
        this.blocker.getElement().getStyle().setZIndex(1000);
        this.blocker.getElement().getStyle().setTop(0.0, Style.Unit.PX);
        this.blocker.getElement().getStyle().setLeft(0.0, Style.Unit.PX);
        this.blocker.getElement().getStyle().setOpacity((double)0.1f);
        this.blocker.getElement().getStyle().setBackgroundColor("grey");
        this.blocker.getElement().getStyle().setPosition(Style.Position.ABSOLUTE);
        this.dragResizeWidget((PopupPanel)this, 0, 0);
    }

    public void addBeforeBarButtons(Widget widget) {
        this.ctrlGrid.setWidget(0, 0, widget);
    }

    protected void updateCursor(DragMode dragMode) {
        this.updateCursor(dragMode, (Element)this.getElement());
        com.google.gwt.user.client.Element top = this.getCellElement(0, 1);
        this.updateCursor(dragMode, (Element)top);
        top = Element.as((Node)top.getFirstChild());
        if (top != null) {
            this.updateCursor(dragMode, (Element)top);
        }
    }

    public void onBrowserEvent(Event event) {
        switch (event.getTypeInt()) {
            case 4: 
            case 8: 
            case 16: 
            case 32: 
            case 64: {
                if (this.dragMode != null || this.calcDragMode(event.getClientX(), event.getClientY()) != null) {
                    switch (DOM.eventGetType((Event)event)) {
                        case 16: 
                        case 32: {
                            Element related = (Element)event.getRelatedEventTarget().cast();
                            if (related == null || !this.getElement().isOrHasChild((Node)related)) break;
                            return;
                        }
                    }
                    DomEvent.fireNativeEvent((NativeEvent)event, (HasHandlers)this, (Element)this.getElement());
                    return;
                }
                if (this.dragMode != null) break;
                this.updateCursor(this.dragMode);
            }
        }
        super.onBrowserEvent(event);
    }

    private int getRelX(Element resize, int clientX) {
        return clientX - resize.getAbsoluteLeft() + resize.getScrollLeft() + resize.getOwnerDocument().getScrollLeft();
    }

    private int getRelY(Element resize, int clientY) {
        return clientY - resize.getAbsoluteTop() + resize.getScrollTop() + resize.getOwnerDocument().getScrollTop();
    }

    protected DragMode calcDragMode(int clientX, int clientY) {
        int tolerance = 5;
        Element resize = this.getCellElement(2, 2).getParentElement();
        int xr = this.getRelX(resize, clientX);
        int yr = this.getRelY(resize, clientY);
        int w = resize.getClientWidth();
        int h = resize.getClientHeight();
        if (xr >= 0 && xr <= w && yr >= -tolerance && yr <= h || yr >= 0 && yr <= h && xr >= -tolerance && xr <= w) {
            return DragMode.SOUTH_EAST_RESIZE;
        }
        resize = this.getCellElement(2, 0).getParentElement();
        xr = this.getRelX(resize, clientX);
        yr = this.getRelY(resize, clientY);
        w = resize.getClientWidth();
        h = resize.getClientHeight();
        if (xr >= 0 && xr <= w && yr >= -tolerance && yr <= h || yr >= 0 && yr <= h && xr >= 0 && xr <= w + tolerance) {
            return DragMode.SOUTH_WEST_RESIZE;
        }
        resize = this.getCellElement(1, 0).getParentElement();
        xr = this.getRelX(resize, clientX);
        yr = this.getRelY(resize, clientY);
        w = resize.getClientWidth();
        h = resize.getClientHeight();
        if (xr >= 0 && xr <= w) {
            return DragMode.WEST_RESIZE;
        }
        resize = this.getCellElement(2, 1).getParentElement();
        xr = this.getRelX(resize, clientX);
        yr = this.getRelY(resize, clientY);
        w = resize.getClientWidth();
        h = resize.getClientHeight();
        if (yr >= 0 && yr <= h) {
            return DragMode.SOUTH_RESIZE;
        }
        resize = this.getCellElement(1, 2).getParentElement();
        xr = this.getRelX(resize, clientX);
        yr = this.getRelY(resize, clientY);
        w = resize.getClientWidth();
        h = resize.getClientHeight();
        if (xr >= 0 && xr <= w) {
            return DragMode.EAST_RESIZE;
        }
        resize = this.getCellElement(0, 1).getParentElement();
        xr = this.getRelX(resize, clientX);
        yr = this.getRelY(resize, clientY);
        w = resize.getClientWidth();
        h = resize.getClientHeight();
        if (yr >= 0 && yr <= h && xr < w - 100) {
            return DragMode.MOVE;
        }
        return null;
    }

    protected void dragResizeWidget(PopupPanel panel, int dx, int dy) {
        Widget widget = panel.getWidget();
        int x = this.getPopupLeft();
        int y = this.getPopupTop();
        int w = widget.getOffsetWidth();
        int h = widget.getOffsetHeight();
        if (this.dragMode != null) {
            int toAdd;
            if (this.dragMode.isEast() || this.dragMode.isWest()) {
                if (this.dragMode.isWest()) {
                    x += dx;
                    if ((w -= dx) < this.minWidth) {
                        toAdd = this.minWidth - w;
                        x -= toAdd;
                        w += toAdd;
                    }
                } else if ((w += dx) < this.minWidth) {
                    w = this.minWidth;
                }
            }
            if (this.dragMode.isNorth() || this.dragMode.isSouth()) {
                if (this.dragMode.isNorth()) {
                    y += dy;
                    if ((h -= dy) < this.minHeight) {
                        toAdd = this.minHeight - h;
                        h += toAdd;
                        y -= toAdd;
                    }
                } else if ((h += dy) < this.minHeight) {
                    h = this.minHeight;
                }
                h = h < this.minHeight ? this.minHeight : h;
            }
        }
        widget.setHeight(String.valueOf(h) + "px");
        widget.setWidth(String.valueOf(w) + "px");
        panel.setPopupPosition(x, y);
        this.blocker.setWidth(String.valueOf(this.getOffsetWidth()) + "px");
        this.blocker.setHeight(String.valueOf(this.getOffsetHeight()) + "px");
    }

    protected void beginDragging(MouseDownEvent event) {
        this.container.add((Widget)this.blocker);
        this.blocker.setWidth(String.valueOf(this.getOffsetWidth()) + "px");
        this.blocker.setHeight(String.valueOf(this.getOffsetHeight()) + "px");
        DragMode dm = this.calcDragMode(event.getClientX(), event.getClientY());
        if (dm != null && dm != DragMode.MOVE) {
            this.dragMode = dm;
            DOM.setCapture((Element)this.getElement());
            this.dragX = event.getClientX();
            this.dragY = event.getClientY();
            this.updateCursor(dm, (Element)RootPanel.get().getElement());
        } else {
            super.beginDragging(event);
        }
    }

    protected void continueDragging(MouseMoveEvent event) {
        if (this.dragMode != null && this.dragMode != DragMode.MOVE) {
            this.updateCursor(this.dragMode);
            int dx = event.getClientX() - this.dragX;
            int dy = event.getClientY() - this.dragY;
            this.dragX = event.getClientX();
            this.dragY = event.getClientY();
            this.dragResizeWidget((PopupPanel)this, dx, dy);
        } else {
            DragMode dm = this.calcDragMode(event.getClientX(), event.getClientY());
            this.updateCursor(dm);
            super.continueDragging(event);
        }
    }

    protected void onPreviewNativeEvent(Event.NativePreviewEvent event) {
        NativeEvent nativeEvent = event.getNativeEvent();
        if (!event.isCanceled() && event.getTypeInt() == 4 && this.calcDragMode(nativeEvent.getClientX(), nativeEvent.getClientY()) != null) {
            nativeEvent.preventDefault();
        }
        super.onPreviewNativeEvent(event);
    }

    protected void endDragging(MouseUpEvent event) {
        this.container.remove((Widget)this.blocker);
        if (this.dragMode != null && this.dragMode != DragMode.MOVE) {
            DOM.releaseCapture((Element)this.getElement());
            this.dragX = event.getClientX() - this.dragX;
            this.dragY = event.getClientY() - this.dragY;
            this.dragMode = null;
            this.updateCursor(this.dragMode);
            RootPanel.get().getElement().getStyle().setCursor(Style.Cursor.AUTO);
        } else {
            super.endDragging(event);
        }
    }

    public void setWidget(Widget widget) {
        Widget old = this.getWidget();
        if (old != null) {
            this.container.remove(old);
        }
        this.container.add(widget);
    }

    public Widget getWidget() {
        int i = 0;
        while (i < this.container.getWidgetCount()) {
            Widget w = this.container.getWidget(i);
            if (w != this.blocker && w != this.controlsPanel) {
                return w;
            }
            ++i;
        }
        return null;
    }

    public boolean remove(Widget w) {
        return this.container.remove(w);
    }

    protected void onCloseClick(ClickEvent event) {
        this.hide();
    }

    protected void onPopoutClick(ClickEvent event) {
        if (this.popoutHandler != null) {
            this.popoutHandler.popout();
        }
    }

    private static enum DragMode {
        NORTH_WEST_RESIZE(true, false, true, false),
        SOUTH_EAST_RESIZE(false, true, false, true),
        NORTH_RESIZE(true, false, false, false),
        NORTH_EAST_RESIZE(true, false, false, true),
        WEST_RESIZE(false, false, true, false),
        EAST_RESIZE(false, false, false, true),
        SOUTH_WEST_RESIZE(false, true, true, false),
        SOUTH_RESIZE(false, true, false, false),
        MOVE(false, false, false, false);

        private boolean north;
        private boolean south;
        private boolean west;
        private boolean east;

        private DragMode(boolean north, boolean south, boolean west, boolean east) {
            this.north = north;
            this.south = south;
            this.west = west;
            this.east = east;
        }

        public boolean isNorth() {
            return this.north;
        }

        public boolean isSouth() {
            return this.south;
        }

        public boolean isWest() {
            return this.west;
        }

        public boolean isEast() {
            return this.east;
        }
    }

    public static interface PopoutHandler {
        public void popout();
    }

    public static interface WindowBoxResources
    extends ClientBundle {
        public static final WindowBoxResources INSTANCE = (WindowBoxResources)GWT.create(WindowBoxResources.class);

        @CssResource.NotStrict
        @ClientBundle.Source(value={"WindowBox.css"})
        public CssResource windowBoxCss();
    }
}

