/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sse.gwt.client.controls.progressbar;

import com.google.gwt.dom.client.Document;
import com.google.gwt.dom.client.Style;
import com.google.gwt.user.client.ui.Widget;
import java.util.Objects;

public class CustomProgressBar
extends Widget {
    private static final String TAG = "progress";
    private static final String ATTR_MAX = "max";
    private static final String ATTR_VALUE = "value";

    public static CustomProgressBar indeterminate() {
        return new CustomProgressBar();
    }

    public static CustomProgressBar determinate() {
        CustomProgressBar progressBar = CustomProgressBar.indeterminate();
        progressBar.setValue(0.0);
        return progressBar;
    }

    public static CustomProgressBar determinate(double max) {
        CustomProgressBar progressBar = CustomProgressBar.determinate();
        progressBar.setMax(max);
        return progressBar;
    }

    private CustomProgressBar() {
        this.setElement(Document.get().createElement(TAG));
        this.getElement().getStyle().setWidth(100.0, Style.Unit.PCT);
        this.getElement().getStyle().setHeight(2.0, Style.Unit.EM);
    }

    public final double getMax() {
        return this.getDoubleAttribute(ATTR_MAX);
    }

    public final void setMax(double max) {
        this.setDoubleAtrribute(ATTR_MAX, max);
    }

    public final double getValue() {
        return this.getDoubleAttribute(ATTR_VALUE);
    }

    public final void setValue(double value) {
        this.setDoubleAtrribute(ATTR_VALUE, value);
    }

    private double getDoubleAttribute(String attrName) {
        String attrValue = this.getElement().getAttribute(attrName);
        return Objects.isNull(attrValue) || attrValue.isEmpty() ? null : Double.valueOf(Double.parseDouble(attrValue));
    }

    private void setDoubleAtrribute(String attrName, double attrValue) {
        this.getElement().setAttribute(attrName, Double.toString(attrValue));
    }
}

