/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sse.gwt.client.controls.languageselect;

import com.google.gwt.core.client.GWT;
import com.google.gwt.dom.client.Style;
import com.google.gwt.http.client.UrlBuilder;
import com.google.gwt.i18n.client.LocaleInfo;
import com.google.gwt.text.shared.AbstractRenderer;
import com.google.gwt.text.shared.Renderer;
import com.google.gwt.uibinder.client.UiBinder;
import com.google.gwt.uibinder.client.UiConstructor;
import com.google.gwt.uibinder.client.UiField;
import com.google.gwt.user.client.Window;
import com.google.gwt.user.client.ui.Anchor;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.InlineLabel;
import com.google.gwt.user.client.ui.ValueListBox;
import com.google.gwt.user.client.ui.Widget;
import com.sap.sse.common.Util;
import com.sap.sse.gwt.client.GWTLocaleUtil;
import java.util.List;
import java.util.Optional;

public class LanguageSelector
extends Composite {
    private static LanguageSelectorUiBinder uiBinder = (LanguageSelectorUiBinder)GWT.create(LanguageSelectorUiBinder.class);
    @UiField
    InlineLabel labelUi;
    @UiField
    Anchor languageSwitchLinkUi;
    @UiField(provided=true)
    ValueListBox<String> languageSelectionUi = new ValueListBox((Renderer)new LanguageRenderer());

    @UiConstructor
    public LanguageSelector() {
        this.initWidget((Widget)uiBinder.createAndBindUi((Object)this));
        this.initLanguages(LocaleInfo.getCurrentLocale());
        this.labelUi.getElement().getStyle().setDisplay(Style.Display.NONE);
    }

    public void setLabelText(String labelText) {
        this.labelUi.getElement().getStyle().clearDisplay();
        this.labelUi.setText(labelText);
    }

    private void initLanguages(LocaleInfo currentLocale) {
        List availableLocales = Util.asList(GWTLocaleUtil.getAvailableLocales());
        if (availableLocales.size() <= 1) {
            this.removeFromParent();
        } else if (availableLocales.size() == 2) {
            this.initLanguageSwitchLink(availableLocales, currentLocale);
        } else {
            this.initLanguageSelection(availableLocales, currentLocale);
        }
    }

    private void initLanguageSwitchLink(List<String> available, LocaleInfo current) {
        this.languageSelectionUi.removeFromParent();
        Optional<String> other = available.stream().filter(l -> !current.getLocaleName().equals(l)).findFirst();
        other.ifPresent(name -> {
            this.languageSwitchLinkUi.setText(LocaleInfo.getLocaleNativeDisplayName((String)name));
            this.languageSwitchLinkUi.addClickHandler(e -> this.switchLanguage((String)name));
        });
    }

    private void initLanguageSelection(List<String> available, LocaleInfo current) {
        this.languageSwitchLinkUi.removeFromParent();
        this.languageSelectionUi.setValue((Object)current.getLocaleName());
        this.languageSelectionUi.setAcceptableValues(available);
        this.languageSelectionUi.addValueChangeHandler(event -> {
            if (!current.getLocaleName().equals(event.getValue())) {
                this.switchLanguage((String)event.getValue());
            }
        });
    }

    private void switchLanguage(String newLocaleName) {
        UrlBuilder builder = Window.Location.createUrlBuilder().setParameter("locale", new String[]{newLocaleName});
        String hash = Window.Location.getHash();
        builder.setHash(null);
        String newUrl = hash == null ? builder.buildString() : (hash.startsWith("#") ? String.valueOf(builder.buildString()) + hash : String.valueOf(builder.buildString()) + "#" + hash);
        Window.Location.replace((String)newUrl);
    }

    private static class LanguageRenderer
    extends AbstractRenderer<String> {
        private LanguageRenderer() {
        }

        public String render(String object) {
            String displayName = LocaleInfo.getLocaleNativeDisplayName((String)object);
            return displayName == null ? "" : displayName;
        }
    }

    static interface LanguageSelectorUiBinder
    extends UiBinder<Widget, LanguageSelector> {
    }
}

