/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sse.gwt.client.controls.filestorage;

import com.google.gwt.cell.client.Cell;
import com.google.gwt.cell.client.FieldUpdater;
import com.google.gwt.core.client.Callback;
import com.google.gwt.event.dom.client.ChangeEvent;
import com.google.gwt.event.dom.client.ChangeHandler;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.i18n.client.LocaleInfo;
import com.google.gwt.user.cellview.client.CellTable;
import com.google.gwt.user.cellview.client.Column;
import com.google.gwt.user.cellview.client.HasKeyboardSelectionPolicy;
import com.google.gwt.user.cellview.client.TextColumn;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.Button;
import com.google.gwt.user.client.ui.CaptionPanel;
import com.google.gwt.user.client.ui.FlowPanel;
import com.google.gwt.user.client.ui.HorizontalPanel;
import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.ListBox;
import com.google.gwt.user.client.ui.VerticalPanel;
import com.google.gwt.user.client.ui.Widget;
import com.google.gwt.view.client.ListDataProvider;
import com.sap.sse.gwt.client.ErrorReporter;
import com.sap.sse.gwt.client.celltable.BaseCelltable;
import com.sap.sse.gwt.client.controls.TabbingTextInputCell;
import com.sap.sse.gwt.client.controls.filestorage.StringMessages;
import com.sap.sse.gwt.client.filestorage.FileStorageManagementGwtServiceAsync;
import com.sap.sse.gwt.shared.filestorage.FileStorageServiceDTO;
import com.sap.sse.gwt.shared.filestorage.FileStorageServicePropertyDTO;
import com.sap.sse.gwt.shared.filestorage.FileStorageServicePropertyErrorsDTO;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class FileStoragePanel
extends FlowPanel {
    private final StringMessages stringMessages = StringMessages.INSTANCE;
    private final FileStorageManagementGwtServiceAsync sailingService;
    private final ErrorReporter errorReporter;
    private final Label activeServiceLabel;
    private final ListBox servicesListBox;
    private CellTable<FileStorageServicePropertyDTO> propertiesTable;
    private final Label serviceDescriptionLabel;
    private final Label propertiesErrorLabel;
    private final List<FileStorageServicePropertyDTO> properties;
    private final Map<String, FileStorageServiceDTO> availableServices = new HashMap<String, FileStorageServiceDTO>();
    private final Map<FileStorageServicePropertyDTO, String> perPropertyErrors = new HashMap<FileStorageServicePropertyDTO, String>();
    private final ListDataProvider<FileStorageServicePropertyDTO> propertiesListDataProvider;
    private final TabbingTextInputCell valueCell;

    public FileStoragePanel(FileStorageManagementGwtServiceAsync sailingService, ErrorReporter errorReporter) {
        this.sailingService = sailingService;
        this.errorReporter = errorReporter;
        Button refreshButton = new Button(this.stringMessages.refresh());
        refreshButton.addClickHandler(new ClickHandler(){

            public void onClick(ClickEvent event) {
                FileStoragePanel.this.refresh();
            }
        });
        this.add((Widget)refreshButton);
        CaptionPanel activeServicePanel = new CaptionPanel(this.stringMessages.active());
        this.activeServiceLabel = new Label();
        activeServicePanel.add((Widget)this.activeServiceLabel);
        this.add((Widget)activeServicePanel);
        CaptionPanel editServicePanel = new CaptionPanel(this.stringMessages.edit());
        VerticalPanel editServicePanelContent = new VerticalPanel();
        editServicePanel.add((Widget)editServicePanelContent);
        this.servicesListBox = new ListBox();
        this.servicesListBox.ensureDebugId("servicesListBox");
        this.servicesListBox.addChangeHandler(new ChangeHandler(){

            public void onChange(ChangeEvent event) {
                FileStoragePanel.this.onServiceSelectionChanged();
            }
        });
        editServicePanelContent.add((Widget)this.servicesListBox);
        this.serviceDescriptionLabel = new Label();
        editServicePanelContent.add((Widget)this.serviceDescriptionLabel);
        this.propertiesTable = new BaseCelltable<FileStorageServicePropertyDTO>();
        this.propertiesTable.setKeyboardSelectionPolicy(HasKeyboardSelectionPolicy.KeyboardSelectionPolicy.DISABLED);
        this.propertiesListDataProvider = new ListDataProvider(new ArrayList());
        this.properties = this.propertiesListDataProvider.getList();
        this.propertiesListDataProvider.addDataDisplay(this.propertiesTable);
        TextColumn<FileStorageServicePropertyDTO> nameColumn = new TextColumn<FileStorageServicePropertyDTO>(){

            public String getValue(FileStorageServicePropertyDTO p) {
                return p.name;
            }
        };
        this.propertiesTable.addColumn((Column)nameColumn, this.stringMessages.name());
        this.valueCell = new TabbingTextInputCell();
        Column<FileStorageServicePropertyDTO, String> inputColumn = new Column<FileStorageServicePropertyDTO, String>((Cell)this.valueCell){

            public String getValue(FileStorageServicePropertyDTO object) {
                return object.value;
            }
        };
        inputColumn.setFieldUpdater((FieldUpdater)new FieldUpdater<FileStorageServicePropertyDTO, String>(){

            public void update(int index, FileStorageServicePropertyDTO object, String value) {
                object.value = value;
            }
        });
        this.propertiesTable.addColumn((Column)inputColumn, this.stringMessages.value());
        TextColumn<FileStorageServicePropertyDTO> descriptionColumn = new TextColumn<FileStorageServicePropertyDTO>(){

            public String getValue(FileStorageServicePropertyDTO p) {
                return p.description;
            }
        };
        this.propertiesTable.addColumn((Column)descriptionColumn, this.stringMessages.description());
        TextColumn<FileStorageServicePropertyDTO> errorColumn = new TextColumn<FileStorageServicePropertyDTO>(){

            public String getValue(FileStorageServicePropertyDTO p) {
                String error = (String)FileStoragePanel.this.perPropertyErrors.get(p);
                return error == null ? "" : error;
            }
        };
        errorColumn.setCellStyleNames("errorLabel");
        this.propertiesTable.addColumn((Column)errorColumn, this.stringMessages.error());
        editServicePanelContent.add(this.propertiesTable);
        this.propertiesErrorLabel = new Label();
        this.propertiesErrorLabel.setStyleName("errorLabel");
        editServicePanelContent.add((Widget)this.propertiesErrorLabel);
        HorizontalPanel buttonsPanel = new HorizontalPanel();
        Button saveAndTestPropertiesButton = new Button(this.stringMessages.save());
        saveAndTestPropertiesButton.addClickHandler(new ClickHandler(){

            public void onClick(ClickEvent event) {
                FileStoragePanel.this.saveAndTestProperties((Callback<Void, Void>)null);
            }
        });
        buttonsPanel.add((Widget)saveAndTestPropertiesButton);
        Button setAsActiveServiceButton = new Button(this.stringMessages.setAsActive());
        setAsActiveServiceButton.addClickHandler(new ClickHandler(){

            public void onClick(ClickEvent event) {
                FileStoragePanel.this.setAsActiveService();
            }
        });
        buttonsPanel.add((Widget)setAsActiveServiceButton);
        editServicePanelContent.add((Widget)buttonsPanel);
        this.add((Widget)editServicePanel);
        this.refresh();
    }

    private String getSelectedServiceName() {
        int i = this.servicesListBox.getSelectedIndex();
        return i < 0 ? "" : this.servicesListBox.getItemText(i);
    }

    private void testProperties(final Callback<Void, Void> callback) {
        this.sailingService.testFileStorageServiceProperties(this.getSelectedServiceName(), this.getLocaleInfo(), new AsyncCallback<FileStorageServicePropertyErrorsDTO>(){

            public void onSuccess(FileStorageServicePropertyErrorsDTO result) {
                FileStoragePanel.this.perPropertyErrors.clear();
                FileStoragePanel.this.propertiesErrorLabel.setText("");
                if (result != null) {
                    FileStoragePanel.this.perPropertyErrors.putAll(result.perPropertyMessages);
                    FileStoragePanel.this.propertiesErrorLabel.setText(result.message);
                }
                if (callback != null) {
                    callback.onSuccess(null);
                }
                int i = 0;
                while (i < FileStoragePanel.this.properties.size()) {
                    FileStorageServicePropertyDTO p = (FileStorageServicePropertyDTO)FileStoragePanel.this.properties.get(i);
                    if (p.isPassword) {
                        p.value = null;
                        FileStoragePanel.this.valueCell.clearViewData(p);
                    }
                    ++i;
                }
                FileStoragePanel.this.propertiesListDataProvider.refresh();
            }

            public void onFailure(Throwable caught) {
                FileStoragePanel.this.errorReporter.reportError(String.valueOf(FileStoragePanel.this.stringMessages.couldNotTestProperties()) + ": " + caught.getMessage());
            }
        });
    }

    private void saveProperties(final Callback<Void, Void> callback) {
        HashMap<String, String> values = new HashMap<String, String>();
        for (FileStorageServicePropertyDTO p : this.properties) {
            values.put(p.name, p.value);
        }
        this.perPropertyErrors.clear();
        this.sailingService.setFileStorageServiceProperties(this.getSelectedServiceName(), values, new AsyncCallback<Void>(){

            public void onSuccess(Void result) {
                if (callback != null) {
                    callback.onSuccess(null);
                }
            }

            public void onFailure(Throwable caught) {
                FileStoragePanel.this.errorReporter.reportError(String.valueOf(FileStoragePanel.this.stringMessages.couldNotSetProperties()) + ": " + caught.getMessage());
            }
        });
    }

    private void saveAndTestProperties(final Callback<Void, Void> callback) {
        this.saveProperties(new Callback<Void, Void>(){

            public void onSuccess(Void result) {
                FileStoragePanel.this.testProperties((Callback<Void, Void>)callback);
            }

            public void onFailure(Void reason) {
            }
        });
    }

    private void setAsActiveService() {
        this.saveAndTestProperties(new Callback<Void, Void>(){

            public void onSuccess(Void result) {
                FileStoragePanel.this.sailingService.setActiveFileStorageService(FileStoragePanel.this.getSelectedServiceName(), FileStoragePanel.this.getLocaleInfo(), new AsyncCallback<Void>(){

                    public void onSuccess(Void result) {
                        FileStoragePanel.this.activeServiceLabel.setText(FileStoragePanel.this.getSelectedServiceName());
                    }

                    public void onFailure(Throwable caught) {
                        FileStoragePanel.this.errorReporter.reportError(String.valueOf(FileStoragePanel.this.stringMessages.couldNotSetActiveService()) + ": " + caught.getMessage());
                    }
                });
            }

            public void onFailure(Void reason) {
            }
        });
    }

    private void onServiceSelectionChanged() {
        this.properties.clear();
        this.perPropertyErrors.clear();
        this.serviceDescriptionLabel.setText("");
        FileStorageServiceDTO selected = this.availableServices.get(this.getSelectedServiceName());
        if (selected != null) {
            this.serviceDescriptionLabel.setText(selected.description);
            this.properties.addAll(Arrays.asList(selected.properties));
        }
    }

    private String getLocaleInfo() {
        return LocaleInfo.getCurrentLocale().getLocaleName();
    }

    private void refresh() {
        String oldSelectedService = this.getSelectedServiceName();
        this.servicesListBox.clear();
        this.servicesListBox.addItem("");
        this.availableServices.clear();
        this.propertiesErrorLabel.setText("");
        this.perPropertyErrors.clear();
        this.onServiceSelectionChanged();
        this.sailingService.getActiveFileStorageServiceName(new AsyncCallback<String>(){

            public void onSuccess(String result) {
                FileStoragePanel.this.activeServiceLabel.setText(result);
            }

            public void onFailure(Throwable caught) {
                FileStoragePanel.this.errorReporter.reportError(String.valueOf(FileStoragePanel.this.stringMessages.couldNotLoadActiveService()) + ": " + caught.getMessage());
            }
        });
        this.sailingService.getAvailableFileStorageServices(this.getLocaleInfo(), new AsyncCallback<FileStorageServiceDTO[]>(){

            public void onSuccess(FileStorageServiceDTO[] result) {
                FileStorageServiceDTO[] fileStorageServiceDTOArray = result;
                int n = result.length;
                int n2 = 0;
                while (n2 < n) {
                    FileStorageServiceDTO service = fileStorageServiceDTOArray[n2];
                    FileStoragePanel.this.availableServices.put(service.name, service);
                    FileStoragePanel.this.servicesListBox.addItem(service.name);
                    ++n2;
                }
            }

            public void onFailure(Throwable caught) {
                FileStoragePanel.this.errorReporter.reportError(String.valueOf(FileStoragePanel.this.stringMessages.couldNotLoadAvailableServices()) + ": " + caught.getMessage());
            }
        });
        int i = 0;
        while (i < this.servicesListBox.getItemCount()) {
            if (this.servicesListBox.getItemText(i).equals(oldSelectedService)) {
                this.servicesListBox.setSelectedIndex(i);
            }
            ++i;
        }
        this.onServiceSelectionChanged();
        this.testProperties(null);
    }
}

