/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sse.gwt.client.controls.carousel;

import com.google.gwt.core.client.GWT;
import com.google.gwt.core.client.Scheduler;
import com.google.gwt.dom.client.Document;
import com.google.gwt.dom.client.Style;
import com.google.gwt.uibinder.client.UiBinder;
import com.google.gwt.uibinder.client.UiField;
import com.google.gwt.user.client.Command;
import com.google.gwt.user.client.Element;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.HTMLPanel;
import com.google.gwt.user.client.ui.Widget;
import com.sap.sse.gwt.client.controls.carousel.LazyLoadable;
import java.util.Iterator;
import java.util.LinkedList;

public class WidgetCarousel
extends Composite {
    private static SlickSliderUiBinder ourUiBinder = (SlickSliderUiBinder)GWT.create(SlickSliderUiBinder.class);
    @UiField
    HTMLPanel sliderMainUi;
    private boolean showDots = true;
    private boolean infiniteScrolling = true;
    private final String uniqueId;
    private boolean showArrows = true;
    private LinkedList<Widget> items = new LinkedList();
    private boolean initialized;

    public WidgetCarousel() {
        this.initWidget((Widget)ourUiBinder.createAndBindUi((Object)this));
        this.uniqueId = Document.get().createUniqueId();
        this.sliderMainUi.addStyleName(this.uniqueId);
        this.sliderMainUi.getElement().getStyle().setHeight(0.0, Style.Unit.PX);
        this.sliderMainUi.getElement().getStyle().setOverflowY(Style.Overflow.HIDDEN);
    }

    private void initializeIfRequired() {
        if (!this.initialized && !this.items.isEmpty() && this.isAttached() && this.isVisible()) {
            this.initialized = true;
            this.initAfterReflow();
        }
    }

    private void initAfterReflow() {
        if (this.items.getFirst().getElement().getOffsetWidth() > 10 && this.items.getFirst().getElement().getOffsetHeight() > 10) {
            this.init();
            this.sliderMainUi.getElement().getStyle().setWidth(100.0, Style.Unit.PCT);
            this.sliderMainUi.getElement().getStyle().setHeight((double)this.items.getFirst().getElement().getOffsetHeight(), Style.Unit.PX);
            Scheduler.get().scheduleDeferred(() -> ((Style)this.sliderMainUi.getElement().getStyle()).clearOverflowY());
        } else {
            Scheduler.get().scheduleDeferred(this::initAfterReflow);
        }
    }

    public void setVisible(boolean visible) {
        super.setVisible(visible);
        this.initializeIfRequired();
    }

    protected void onLoad() {
        super.onLoad();
        Scheduler.get().scheduleFinally(this::initializeIfRequired);
    }

    public void onAfterChange() {
        Iterator iterator = this.items.iterator();
        while (iterator.hasNext()) {
            int previousIdx;
            Widget previousOne;
            Widget nextOne;
            Widget widget = (Widget)iterator.next();
            Element parent = widget.getElement();
            if (parent == null || !parent.getClassName().contains("slick-active")) continue;
            if (iterator.hasNext() && (nextOne = (Widget)iterator.next()) instanceof LazyLoadable) {
                LazyLoadable lazyLoadable = (LazyLoadable)nextOne;
                lazyLoadable.doInitializeLazyComponents();
            }
            if ((previousOne = this.items.get(previousIdx = this.items.indexOf(widget) - 1 < 0 ? this.items.size() - 1 : this.items.indexOf(widget) - 1)) instanceof LazyLoadable) {
                LazyLoadable lazyLoadable = (LazyLoadable)previousOne;
                lazyLoadable.doInitializeLazyComponents();
            }
            return;
        }
    }

    native void setupSlider(WidgetCarousel var1);

    public void setWidgets(Iterable<Widget> slides) {
        assert (this.items.isEmpty());
        for (Widget slide : slides) {
            this.items.add(slide);
            this.sliderMainUi.add(slide);
        }
        if (!this.items.isEmpty()) {
            this.ensureInitialized(this.items.getFirst());
            if (this.items.size() > 1) {
                this.ensureInitialized(this.items.get(1));
            }
            this.ensureInitialized(this.items.getLast());
        }
        this.initializeIfRequired();
    }

    private void ensureInitialized(Widget slide) {
        if (slide instanceof LazyLoadable) {
            LazyLoadable lazyLoadable = (LazyLoadable)slide;
            lazyLoadable.doInitializeLazyComponents();
        }
    }

    public void setInfiniteScrolling(boolean infiniteScrolling) {
        this.infiniteScrolling = infiniteScrolling;
    }

    public void setShowArrows(boolean showArrows) {
        this.showArrows = showArrows;
    }

    public void setShowDots(boolean showDots) {
        this.showDots = showDots;
    }

    private void init() {
        final WidgetCarousel reference = this;
        Scheduler.get().scheduleDeferred((Scheduler.ScheduledCommand)new Command(){

            public void execute() {
                try {
                    WidgetCarousel.this.setupSlider(reference);
                }
                catch (Exception e) {
                    GWT.log((String)"Catched Exception on slider init", (Throwable)e);
                }
            }
        });
    }

    static interface SlickSliderUiBinder
    extends UiBinder<Widget, WidgetCarousel> {
    }
}

