/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sse.gwt.client.controls;

import com.google.gwt.event.dom.client.BlurEvent;
import com.google.gwt.event.dom.client.BlurHandler;
import com.google.gwt.event.dom.client.FocusEvent;
import com.google.gwt.event.dom.client.FocusHandler;
import com.google.gwt.user.client.ui.TextBox;
import com.google.web.bindery.event.shared.HandlerRegistration;

public class TextBoxWithWatermark
extends TextBox
implements BlurHandler,
FocusHandler {
    private String watermark;
    private String watermarkStyleName;
    private HandlerRegistration blurHandler;
    private HandlerRegistration focusHandler;

    public TextBoxWithWatermark() {
    }

    public TextBoxWithWatermark(String defaultValue) {
        this();
        this.setText(defaultValue);
    }

    public TextBoxWithWatermark(String defaultValue, String watermark) {
        this(defaultValue);
        this.setWatermark(watermark);
    }

    public void setWatermark(String watermark) {
        this.watermark = watermark;
        if (watermark != null && !watermark.isEmpty()) {
            this.blurHandler = this.addBlurHandler(this);
            this.focusHandler = this.addFocusHandler(this);
            this.enableWatermark();
        } else {
            this.blurHandler.removeHandler();
            this.focusHandler.removeHandler();
        }
    }

    public void setWatermarkStyleName(String styleName) {
        this.watermarkStyleName = styleName;
    }

    public void onBlur(BlurEvent event) {
        this.enableWatermark();
    }

    private void enableWatermark() {
        String text = this.getText();
        if (text.length() == 0 || text.equalsIgnoreCase(this.watermark)) {
            this.setText(this.watermark);
            if (this.watermarkStyleName != null && !this.watermarkStyleName.isEmpty()) {
                this.addStyleName(this.watermarkStyleName);
            }
        }
    }

    public void onFocus(FocusEvent event) {
        if (this.watermarkStyleName != null && !this.watermarkStyleName.isEmpty()) {
            this.removeStyleName(this.watermarkStyleName);
        }
        if (this.getText().equalsIgnoreCase(this.watermark)) {
            this.setText("");
        }
    }
}

