/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sse.gwt.client.celltable;

import com.google.gwt.user.cellview.client.CellTable;
import com.google.gwt.user.cellview.client.Column;
import com.google.gwt.user.cellview.client.ColumnSortEvent;
import com.google.gwt.user.cellview.client.ColumnSortList;
import com.google.gwt.user.cellview.client.Header;
import com.google.gwt.view.client.HasData;
import com.google.gwt.view.client.ListDataProvider;
import com.sap.sse.common.InvertibleComparator;
import com.sap.sse.gwt.client.celltable.BaseCelltable;
import com.sap.sse.gwt.client.celltable.SortableColumn;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class SortedCellTable<T>
extends BaseCelltable<T> {
    private Column<T, ?> currentlySortedColumn;
    private Map<Column<T, ?>, Boolean> defaultSortOrderMap = new HashMap();
    private Map<Column<T, ?>, InvertibleComparator<T>> comparators = new HashMap();
    private Column<T, ?> initialSortColumn;
    private ListDataProvider<T> dataProvider = new ListDataProvider();
    private ColumnSortEvent.ListHandler<T> columnSortHandler;

    public SortedCellTable(int pageSize, CellTable.Resources resources) {
        super(pageSize, resources);
        this.dataProvider.addDataDisplay((HasData)this);
        this.columnSortHandler = new ColumnSortEvent.ListHandler<T>(this.dataProvider.getList()){

            public void onColumnSort(ColumnSortEvent event) {
                boolean ascending;
                Column column = event.getColumn();
                if (column == null) {
                    return;
                }
                InvertibleComparator comparator = (InvertibleComparator)SortedCellTable.this.comparators.get(column);
                if (comparator == null) {
                    return;
                }
                if (column.equals(SortedCellTable.this.currentlySortedColumn)) {
                    comparator.invertOrder();
                    ascending = comparator.isAscending();
                } else {
                    ascending = (Boolean)SortedCellTable.this.defaultSortOrderMap.get(column);
                    comparator.setAscending(ascending);
                }
                SortedCellTable.this.sortColumn(column, (Comparator)comparator, ascending);
            }

            public void setComparator(Column<T, ?> column, Comparator<T> comparator) {
                SortedCellTable.this.comparators.put(column, (InvertibleComparator)comparator);
                super.setComparator(column, comparator);
            }
        };
        this.addColumnSortHandler((ColumnSortEvent.Handler)this.columnSortHandler);
    }

    public Column<T, ?> getCurrentlySortedColumn() {
        return this.currentlySortedColumn;
    }

    public void sort() {
        InvertibleComparator<T> comparator;
        if (this.currentlySortedColumn != null && (comparator = this.comparators.get(this.currentlySortedColumn)) != null) {
            this.sortColumn(this.currentlySortedColumn, (Comparator<T>)comparator, comparator.isAscending());
        }
    }

    public void sortColumn(Column<T, ?> column) {
        InvertibleComparator<T> comparator = this.comparators.get(column);
        if (comparator != null) {
            this.sortColumn(column, (Comparator<T>)comparator, comparator.isAscending());
        }
    }

    public void sortColumn(Column<T, ?> column, boolean ascending) {
        InvertibleComparator<T> comparator = this.comparators.get(column);
        if (comparator != null) {
            this.sortColumn(column, (Comparator<T>)comparator, ascending);
        }
    }

    private void sortColumn(Column<T, ?> column, Comparator<T> comparator, boolean ascending) {
        if (ascending) {
            Collections.sort(this.dataProvider.getList(), comparator);
        } else {
            Collections.sort(this.dataProvider.getList(), Collections.reverseOrder(comparator));
        }
        this.getColumnSortList().push(new ColumnSortList.ColumnSortInfo(column, ascending));
        this.currentlySortedColumn = column;
    }

    public void addColumn(Column<T, ?> column, String headerName, InvertibleComparator<T> comparator, boolean ascendingSorting) {
        this.addColumn(column, headerName);
        column.setSortable(comparator != null);
        if (comparator != null) {
            this.defaultSortOrderMap.put(column, ascendingSorting);
            this.comparators.put(column, comparator);
        }
    }

    public void addColumn(SortableColumn<T, ?> column) {
        this.addColumn(column, column.getHeader(), column.getComparator(), column.getPreferredSortingOrder().isAscending());
    }

    public void addColumn(Column<T, ?> column, Header<?> header, InvertibleComparator<T> comparator, boolean ascendingSorting) {
        this.addColumn(column, header);
        column.setSortable(comparator != null);
        if (comparator != null) {
            this.defaultSortOrderMap.put(column, ascendingSorting);
            this.comparators.put(column, comparator);
        }
    }

    public void insertColumn(int beforeIndex, SortableColumn<T, ?> column) {
        this.insertColumn(beforeIndex, column, column.getHeader(), column.getComparator(), column.getPreferredSortingOrder().isAscending());
    }

    public void insertColumn(int beforeIndex, Column<T, ?> column, Header<?> header, InvertibleComparator<T> comparator, boolean ascendingSorting) {
        this.insertColumn(beforeIndex, column, header);
        column.setSortable(comparator != null);
        if (comparator != null) {
            this.defaultSortOrderMap.put(column, ascendingSorting);
            this.comparators.put(column, comparator);
        }
    }

    public void setInitialSortColumn(Column<T, ?> column) {
        this.initialSortColumn = column;
    }

    public void setComparator(Column<T, ?> column, InvertibleComparator<T> comparator) {
        this.columnSortHandler.setComparator(column, comparator);
    }

    public void setDefaultSortOrder(Column<T, ?> column, boolean ascending) {
        this.defaultSortOrderMap.put(column, ascending);
    }

    public void setList(Iterable<T> list) {
        this.dataProvider.getList().clear();
        if (list != null) {
            for (T element : list) {
                this.dataProvider.getList().add(element);
            }
        }
        if (this.initialSortColumn != null) {
            Collections.sort(this.dataProvider.getList(), new Comparator<T>(){

                @Override
                public int compare(T o1, T o2) {
                    return ((Boolean)SortedCellTable.this.defaultSortOrderMap.get(SortedCellTable.this.initialSortColumn) != false ? 1 : -1) * ((InvertibleComparator)SortedCellTable.this.comparators.get(SortedCellTable.this.initialSortColumn)).compare(o1, o2);
                }
            });
            this.getColumnSortList().push(new ColumnSortList.ColumnSortInfo(this.initialSortColumn, this.defaultSortOrderMap.get(this.initialSortColumn).booleanValue()));
            this.currentlySortedColumn = this.initialSortColumn;
        }
    }

    public void setRowData(int start, List<? extends T> values) {
        super.setRowData(start, values);
    }

    public ListDataProvider<T> getDataProvider() {
        return this.dataProvider;
    }

    public void restoreColumnSortInfos(Column<T, ?> defaultSortColumn) {
        List<ColumnSortList.ColumnSortInfo> oldSortInfos;
        ColumnSortList sortList = this.getColumnSortList();
        if (sortList.size() == 0) {
            boolean ascending = this.defaultSortOrderMap.get(defaultSortColumn);
            this.comparators.get(defaultSortColumn).setAscending(ascending);
            oldSortInfos = Collections.singletonList(new ColumnSortList.ColumnSortInfo(defaultSortColumn, ascending));
        } else {
            oldSortInfos = new ArrayList<ColumnSortList.ColumnSortInfo>(sortList.size());
            int i = sortList.size() - 1;
            while (i >= 0) {
                oldSortInfos.add(sortList.get(i));
                --i;
            }
        }
        oldSortInfos.forEach(sortInfo -> this.sortColumn(sortInfo.getColumn()));
    }
}

