/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sse.gwt.client.celltable;

import com.google.gwt.view.client.ListDataProvider;
import com.google.gwt.view.client.MultiSelectionModel;
import com.google.gwt.view.client.ProvidesKey;
import com.google.gwt.view.client.SelectionChangeEvent;
import com.sap.sse.gwt.client.celltable.EntityIdentityComparator;
import com.sap.sse.gwt.client.celltable.EntityIdentityWrapper;
import com.sap.sse.gwt.client.celltable.HasDataAdapter;
import com.sap.sse.gwt.client.celltable.RefreshableSelectionModel;
import java.util.HashMap;
import java.util.List;
import java.util.Set;

public class RefreshableMultiSelectionModel<T>
extends MultiSelectionModel<T>
implements RefreshableSelectionModel<T> {
    final EntityIdentityComparator<T> comp;
    private boolean dontCheckSelectionState = false;
    private final ListDataProvider<T> listDataProvider;

    public RefreshableMultiSelectionModel(final EntityIdentityComparator<T> comp, ListDataProvider<T> listDataProvider) {
        super(comp == null ? null : new ProvidesKey<T>(){

            public Object getKey(T item) {
                return new EntityIdentityWrapper(item, comp);
            }
        });
        this.comp = comp;
        this.listDataProvider = listDataProvider;
        this.listDataProvider.addDataDisplay(new HasDataAdapter<T>(this, listDataProvider));
    }

    @Override
    public EntityIdentityComparator<T> getEntityIdentityComparator() {
        return this.comp;
    }

    @Override
    public boolean itemIsSelectedButNotVisible(List<T> visibleItemList) {
        for (Object item : this.getSelectedSet()) {
            if (visibleItemList.contains(item)) continue;
            return true;
        }
        return false;
    }

    public void setSelected(T item, boolean selected) {
        if (this.comp == null || this.dontCheckSelectionState || item == null || this.getSelectedSet().isEmpty()) {
            super.setSelected(item, selected);
        } else {
            Object wasSelectedBefore = null;
            Set selectedSet = this.getSelectedSet();
            for (Object it : selectedSet) {
                if (!this.comp.representSameEntity(it, item)) continue;
                wasSelectedBefore = it;
                break;
            }
            if (wasSelectedBefore != null) {
                super.setSelected(wasSelectedBefore, false);
                this.isSelected(item);
                super.setSelected(item, selected);
            } else {
                super.setSelected(item, selected);
            }
        }
    }

    @Override
    public void refreshSelectionModel(Iterable<T> newObjects) {
        block9: {
            if (!this.dontCheckSelectionState) {
                this.dontCheckSelectionState = true;
                try {
                    Set selectedSet = this.getSelectedSet();
                    boolean isEmpty = selectedSet.isEmpty();
                    if (isEmpty) break block9;
                    this.clear();
                    if (this.comp == null) {
                        for (T it : newObjects) {
                            boolean selected = selectedSet.contains(it);
                            if (!selected) continue;
                            this.setSelected(it, true);
                        }
                    } else {
                        HashMap<EntityIdentityWrapper<T>, T> wrappedNewObjects = new HashMap<EntityIdentityWrapper<T>, T>();
                        for (T it : newObjects) {
                            wrappedNewObjects.put(new EntityIdentityWrapper<T>(it, this.comp), it);
                        }
                        for (Object selected : selectedSet) {
                            Object newSelectedElement = wrappedNewObjects.remove(new EntityIdentityWrapper<Object>(selected, this.comp));
                            if (newSelectedElement == null) continue;
                            this.setSelected(newSelectedElement, true);
                        }
                    }
                    SelectionChangeEvent.fire((SelectionChangeEvent.HasSelectionChangedHandlers)this);
                }
                finally {
                    this.dontCheckSelectionState = false;
                }
            }
        }
    }
}

