/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sse.gwt.client.celltable;

import com.google.gwt.cell.client.AbstractSafeHtmlCell;
import com.google.gwt.cell.client.Cell;
import com.google.gwt.cell.client.ValueUpdater;
import com.google.gwt.core.client.GWT;
import com.google.gwt.core.client.JavaScriptObject;
import com.google.gwt.dom.client.Element;
import com.google.gwt.dom.client.EventTarget;
import com.google.gwt.dom.client.NativeEvent;
import com.google.gwt.dom.client.Node;
import com.google.gwt.resources.client.ImageResource;
import com.google.gwt.safecss.shared.SafeStyles;
import com.google.gwt.safecss.shared.SafeStylesUtils;
import com.google.gwt.safehtml.client.SafeHtmlTemplates;
import com.google.gwt.safehtml.shared.SafeHtml;
import com.google.gwt.safehtml.shared.SafeHtmlBuilder;
import com.google.gwt.text.shared.SafeHtmlRenderer;
import com.google.gwt.text.shared.SimpleSafeHtmlRenderer;
import com.google.gwt.user.client.ui.AbstractImagePrototype;
import java.util.ArrayList;

public abstract class ImagesBarCell
extends AbstractSafeHtmlCell<String> {
    private static final ImagesBarTemplates imageTemplate = (ImagesBarTemplates)GWT.create(ImagesBarTemplates.class);
    private Cell.Context context;

    public ImagesBarCell() {
        super((SafeHtmlRenderer)SimpleSafeHtmlRenderer.getInstance(), new String[]{"click", "keydown"});
    }

    protected static ImagesBarTemplates getImageTemplate() {
        return imageTemplate;
    }

    public void onBrowserEvent(Cell.Context context, Element parent, String value, NativeEvent event, ValueUpdater<String> valueUpdater) {
        Element el;
        EventTarget eventTarget;
        super.onBrowserEvent(context, parent, (Object)value, event, valueUpdater);
        if ("click".equals(event.getType()) && parent.isOrHasChild((Node)Element.as((JavaScriptObject)(eventTarget = event.getEventTarget()))) && (el = Element.as((JavaScriptObject)eventTarget)).getNodeName().equalsIgnoreCase("IMG")) {
            this.doAction(el.getParentElement().getAttribute("name"), valueUpdater);
        }
    }

    protected void onEnterKeyDown(Cell.Context context, Element parent, String value, NativeEvent event, ValueUpdater<String> valueUpdater) {
        this.doAction(value, valueUpdater);
    }

    protected void doAction(String value, ValueUpdater<String> valueUpdater) {
        if (valueUpdater != null) {
            valueUpdater.update((Object)value);
        }
    }

    protected static AbstractImagePrototype makeImagePrototype(ImageResource resource) {
        return AbstractImagePrototype.create((ImageResource)resource);
    }

    protected abstract Iterable<ImageSpec> getImageSpecs();

    protected Cell.Context getContext() {
        return this.context;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void render(Cell.Context context, SafeHtml data, SafeHtmlBuilder sb) {
        this.context = context;
        if (data == null) return;
        ArrayList<String> allowedActions = new ArrayList<String>();
        String currentAction = "";
        String dataAsString = data.asString();
        boolean escaped = false;
        int i = 0;
        while (i < dataAsString.length()) {
            char character = dataAsString.charAt(i);
            if (escaped) {
                if (character != ',' && character != '\\') throw new IllegalArgumentException("A character other than ',' or '\\' was illegaly escaped.");
                currentAction = String.valueOf(currentAction) + character;
                escaped = false;
            } else if (character == '\\') {
                escaped = true;
            } else if (character == ',') {
                allowedActions.add(currentAction);
                currentAction = "";
            } else {
                currentAction = String.valueOf(currentAction) + character;
            }
            ++i;
        }
        if (escaped) {
            throw new IllegalArgumentException("A '\\' was illegaly found at the end of the data string.");
        }
        allowedActions.add(currentAction);
        SafeStyles imgStyle = this.getImageStyle();
        for (ImageSpec imageSpec : this.getImageSpecs()) {
            if (!dataAsString.equals("*") && !allowedActions.contains(imageSpec.getActionName())) continue;
            SafeHtml rendered = ImagesBarCell.getImageTemplate().cell(imageSpec.getActionName(), imgStyle, imageSpec.getTooltip(), imageSpec.getImagePrototype().getSafeHtml());
            sb.append(rendered);
        }
    }

    protected SafeStyles getImageStyle() {
        return SafeStylesUtils.fromTrustedString((String)"float:left;cursor:hand;cursor:pointer;padding-right:5px;");
    }

    protected class ImageSpec {
        private final AbstractImagePrototype imagePrototype;
        private final String actionName;
        private final String tooltip;

        public ImageSpec(String actionName, String tooltip, ImageResource imageResource) {
            this(actionName, tooltip, AbstractImagePrototype.create((ImageResource)imageResource));
        }

        public ImageSpec(String actionName, String tooltip, AbstractImagePrototype imagePrototype) {
            this.imagePrototype = imagePrototype;
            this.actionName = actionName;
            this.tooltip = tooltip;
        }

        public AbstractImagePrototype getImagePrototype() {
            return this.imagePrototype;
        }

        public String getActionName() {
            return this.actionName;
        }

        public String getTooltip() {
            return this.tooltip;
        }
    }

    static interface ImagesBarTemplates
    extends SafeHtmlTemplates {
        @SafeHtmlTemplates.Template(value="<div name=\"{0}\" style=\"{1}\" title=\"{2}\">{3}</div>")
        public SafeHtml cell(String var1, SafeStyles var2, String var3, SafeHtml var4);
    }
}

