/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sse.gwt.client.celltable;

import com.google.gwt.cell.client.Cell;
import com.google.gwt.cell.client.HasCell;
import com.google.gwt.dom.builder.shared.DivBuilder;
import com.google.gwt.dom.builder.shared.ElementBuilderBase;
import com.google.gwt.dom.builder.shared.TableCellBuilder;
import com.google.gwt.dom.builder.shared.TableRowBuilder;
import com.google.gwt.dom.client.Style;
import com.google.gwt.user.cellview.client.AbstractCellTable;
import com.google.gwt.user.cellview.client.AbstractCellTableBuilder;
import com.google.gwt.user.cellview.client.Column;
import com.google.gwt.user.cellview.client.RowStyles;
import com.google.gwt.user.client.ui.HasHorizontalAlignment;
import com.google.gwt.user.client.ui.HasVerticalAlignment;
import com.google.gwt.view.client.SelectionModel;

public class BaseCellTableBuilder<T>
extends AbstractCellTableBuilder<T> {
    private final String evenRowStyle;
    private final String oddRowStyle;
    private final String selectedRowStyle;
    private final String cellStyle;
    private final String evenCellStyle;
    private final String oddCellStyle;
    private final String firstColumnStyle;
    private final String lastColumnStyle;
    private final String selectedCellStyle;

    public BaseCellTableBuilder(AbstractCellTable<T> cellTable) {
        super(cellTable);
        AbstractCellTable.Style style = cellTable.getResources().style();
        this.evenRowStyle = style.evenRow();
        this.oddRowStyle = style.oddRow();
        this.selectedRowStyle = " " + style.selectedRow();
        this.cellStyle = style.cell();
        this.evenCellStyle = " " + style.evenRowCell();
        this.oddCellStyle = " " + style.oddRowCell();
        this.firstColumnStyle = " " + style.firstColumn();
        this.lastColumnStyle = " " + style.lastColumn();
        this.selectedCellStyle = " " + style.selectedRowCell();
    }

    public void buildRowImpl(T rowValue, int absRowIndex) {
        String extraRowStyles;
        RowStyles rowStyles;
        SelectionModel selectionModel = this.cellTable.getSelectionModel();
        boolean isSelected = selectionModel == null || rowValue == null ? false : selectionModel.isSelected(rowValue);
        boolean isEven = absRowIndex % 2 == 0;
        StringBuilder trClasses = new StringBuilder(isEven ? this.evenRowStyle : this.oddRowStyle);
        if (isSelected) {
            trClasses.append(this.selectedRowStyle);
        }
        if ((rowStyles = this.cellTable.getRowStyles()) != null && (extraRowStyles = rowStyles.getStyleNames(rowValue, absRowIndex)) != null) {
            trClasses.append(" ").append(extraRowStyles);
        }
        TableRowBuilder tr = this.startRow();
        tr.attribute("aria-selected", isSelected ? "true" : "false");
        tr.className(trClasses.toString());
        int columnCount = this.cellTable.getColumnCount();
        int curColumn = 0;
        while (curColumn < columnCount) {
            Cell.Context context;
            String cellStyles;
            Column column = this.cellTable.getColumn(curColumn);
            StringBuilder tdClasses = new StringBuilder(this.cellStyle);
            tdClasses.append(isEven ? this.evenCellStyle : this.oddCellStyle);
            if (curColumn == 0) {
                tdClasses.append(this.firstColumnStyle);
            }
            if (isSelected) {
                tdClasses.append(this.selectedCellStyle);
            }
            if (curColumn == columnCount - 1) {
                tdClasses.append(this.lastColumnStyle);
            }
            if ((cellStyles = column.getCellStyleNames(context = new Cell.Context(absRowIndex, curColumn, this.cellTable.getValueKey(rowValue)), rowValue)) != null) {
                tdClasses.append(" " + cellStyles);
            }
            HasHorizontalAlignment.HorizontalAlignmentConstant hAlign = column.getHorizontalAlignment();
            HasVerticalAlignment.VerticalAlignmentConstant vAlign = column.getVerticalAlignment();
            TableCellBuilder td = tr.startTD();
            td.className(tdClasses.toString());
            if (hAlign != null) {
                td.align(hAlign.getTextAlignString());
            }
            if (vAlign != null) {
                td.vAlign(vAlign.getVerticalAlignString());
            }
            DivBuilder div = td.startDiv();
            div.style().outlineStyle(Style.OutlineStyle.NONE).endStyle();
            this.renderCell((ElementBuilderBase)div, context, (HasCell)column, rowValue);
            div.endDiv();
            td.endTD();
            ++curColumn;
        }
        tr.endTR();
    }
}

