/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sse.gwt.client.celltable;

import com.sap.sse.gwt.client.celltable.ImagesBarCell;
import com.sap.sse.gwt.client.celltable.ImagesBarColumn;
import com.sap.sse.security.shared.HasPermissions;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;

public class ActionsColumn<T, S extends ImagesBarCell>
extends ImagesBarColumn<T, S> {
    protected final Map<String, Consumer<T>> nameToCallbackMap = new HashMap<String, Consumer<T>>();
    protected final Map<String, HasPermissions.Action> nameToActionMap = new HashMap<String, HasPermissions.Action>();
    private final BiFunction<T, HasPermissions.Action, Boolean> permissionChecker;

    public ActionsColumn(S imagesBarCell, BiFunction<T, HasPermissions.Action, Boolean> permissionChecker) {
        super(imagesBarCell);
        this.permissionChecker = permissionChecker;
        this.setFieldUpdater((index, object, value) -> this.nameToCallbackMap.get(value).accept(object));
    }

    @Override
    public final String getValue(T object) {
        return this.mapActions(action -> this.permissionChecker.apply(object, (HasPermissions.Action)action));
    }

    public void addAction(String name, Consumer<T> callback) {
        this.nameToCallbackMap.put(name, callback);
    }

    public void addAction(String name, HasPermissions.Action action, Consumer<T> callback) {
        this.nameToActionMap.put(name, action);
        this.addAction(name, callback);
    }

    protected String mapActions(Function<HasPermissions.Action, Boolean> checker) {
        ArrayList<String> allowedActions = new ArrayList<String>();
        for (String name : this.nameToCallbackMap.keySet()) {
            HasPermissions.Action action = this.nameToActionMap.get(name);
            if (!this.isNotRestrictedOrHasPermission(action, checker)) continue;
            String escapedName = name.replace("\\", "\\\\").replace(",", "\\,");
            allowedActions.add(escapedName);
        }
        return String.join((CharSequence)",", allowedActions);
    }

    private boolean isNotRestrictedOrHasPermission(HasPermissions.Action action, Function<HasPermissions.Action, Boolean> checker) {
        return action == null ? true : checker.apply(action);
    }
}

