/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sse.gwt.client.breadcrumb;

import com.google.gwt.core.shared.GWT;
import com.google.gwt.dom.client.AnchorElement;
import com.google.gwt.dom.client.DivElement;
import com.google.gwt.dom.client.Document;
import com.google.gwt.dom.client.Element;
import com.google.gwt.dom.client.Node;
import com.google.gwt.resources.client.ClientBundle;
import com.google.gwt.resources.client.CssResource;
import com.google.gwt.resources.client.DataResource;
import com.google.gwt.safehtml.shared.SafeUri;
import com.google.gwt.safehtml.shared.UriUtils;
import com.google.gwt.user.client.Event;
import com.google.gwt.user.client.EventListener;
import com.google.gwt.user.client.ui.Widget;
import com.sap.sse.gwt.client.LinkUtil;

public class BreadcrumbPane
extends Widget {
    private static Resources resources;
    private final Style style = BreadcrumbPane.getResources().style();
    private final DivElement breadcrumDiv = Document.get().createDivElement();

    private static Resources getResources() {
        if (resources == null) {
            resources = (Resources)GWT.create(Resources.class);
            resources.style().ensureInjected();
        }
        return resources;
    }

    public BreadcrumbPane() {
        this.breadcrumDiv.addClassName(this.style.event_header__breadcrumb());
        this.setElement((Element)this.breadcrumDiv);
    }

    public void addBreadcrumbItem(String title, String link, Runnable runnable) {
        this.addBreadcrumbItem(title, UriUtils.fromString((String)link), runnable);
    }

    public void addBreadcrumbItem(String title, SafeUri link, final Runnable runnable) {
        AnchorElement breadcrumItem = Document.get().createAnchorElement();
        breadcrumItem.setHref(link);
        breadcrumItem.setInnerText(title);
        breadcrumItem.addClassName(this.style.event_header__breadcrumb__item());
        this.breadcrumDiv.appendChild((Node)breadcrumItem);
        Event.sinkEvents((Element)breadcrumItem, (int)1);
        Event.setEventListener((Element)breadcrumItem, (EventListener)new EventListener(){

            public void onBrowserEvent(Event event) {
                if (LinkUtil.handleLinkClick(event)) {
                    event.stopPropagation();
                    event.preventDefault();
                    runnable.run();
                }
            }
        });
    }

    public void clear() {
        this.breadcrumDiv.removeAllChildren();
    }

    static interface Resources
    extends ClientBundle {
        @ClientBundle.Source(value={"Breadcrumb.gss"})
        public Style style();

        @ClientBundle.Source(value={"backgroundImage.png"})
        public DataResource backgroundImage();
    }

    static interface Style
    extends CssResource {
        public String event_header__breadcrumb();

        public String event_header__breadcrumb__item();
    }
}

