/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.windestimation.model.regressor.twdtransition;

import java.io.Serializable;

public class SupportedDimensionValueRange
implements Serializable {
    private static final long serialVersionUID = -3288594458162374160L;
    public static final double MAX_VALUE = 1.0E11;
    public static final int SQUARE_ROOT_AS_POLYNOMIAL_DEGREE = -1;
    private final double fromInclusive;
    private final double toExclusive;
    private final int polynomialDegree;
    private final boolean withBias;
    private final boolean squareRootInput;

    public SupportedDimensionValueRange(double fromInclusive, double toExclusive, int polynomialDegree, boolean withBias) {
        this.fromInclusive = fromInclusive;
        this.toExclusive = toExclusive;
        this.polynomialDegree = Math.abs(polynomialDegree);
        this.withBias = withBias;
        this.squareRootInput = polynomialDegree == -1;
    }

    public double getFromInclusive() {
        return this.fromInclusive;
    }

    public double getToExclusive() {
        return this.toExclusive;
    }

    public double getSupportedIntervalMiddleValue() {
        return this.fromInclusive + (this.toExclusive - this.fromInclusive) / 2.0;
    }

    public int getPolynomialDegree() {
        return this.polynomialDegree;
    }

    public boolean isWithBias() {
        return this.withBias;
    }

    public boolean isSquareRootInput() {
        return this.squareRootInput;
    }

    public String toString() {
        return "SupportedDimensionValueRange [fromInclusive=" + this.fromInclusive + ", toExclusive=" + this.toExclusive + ", polynomialDegree=" + this.polynomialDegree + ", withBias=" + this.withBias + ", squareRootInput=" + this.squareRootInput + "]";
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        long temp = Double.doubleToLongBits(this.fromInclusive);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        result = 31 * result + this.polynomialDegree;
        result = 31 * result + (this.squareRootInput ? 1231 : 1237);
        temp = Double.doubleToLongBits(this.toExclusive);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        result = 31 * result + (this.withBias ? 1231 : 1237);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        SupportedDimensionValueRange other = (SupportedDimensionValueRange)obj;
        if (Double.doubleToLongBits(this.fromInclusive) != Double.doubleToLongBits(other.fromInclusive)) {
            return false;
        }
        if (this.polynomialDegree != other.polynomialDegree) {
            return false;
        }
        if (this.squareRootInput != other.squareRootInput) {
            return false;
        }
        if (Double.doubleToLongBits(this.toExclusive) != Double.doubleToLongBits(other.toExclusive)) {
            return false;
        }
        return this.withBias == other.withBias;
    }
}

