/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.windestimation.model.regressor.twdtransition;

import com.sap.sailing.windestimation.data.TwdTransition;
import com.sap.sailing.windestimation.model.ModelContext;
import com.sap.sailing.windestimation.model.regressor.twdtransition.SupportedDimensionValueRange;
import com.sap.sailing.windestimation.model.store.ModelDomainType;

public abstract class SingleDimensionBasedTwdTransitionRegressorModelContext
extends ModelContext<TwdTransition> {
    private static final long serialVersionUID = 20422671027132155L;
    private final String dimensionName;
    private final SupportedDimensionValueRange supportedDimensionValueRange;

    public SingleDimensionBasedTwdTransitionRegressorModelContext(String dimensionName, ModelDomainType domainType, SupportedDimensionValueRange supportedDimensionValueRange) {
        super(domainType);
        this.dimensionName = dimensionName;
        this.supportedDimensionValueRange = supportedDimensionValueRange;
    }

    @Override
    public double[] getX(TwdTransition instance) {
        return new double[]{this.getDimensionValue(instance)};
    }

    public double getDimensionValue(TwdTransition instance) {
        double dimensionValue = this.getDimensionValueUnpreprocessed(instance);
        return this.getPreprocessedDimensionValue(dimensionValue);
    }

    public abstract double getDimensionValueUnpreprocessed(TwdTransition var1);

    public double getPreprocessedDimensionValue(double dimensionValue) {
        if (this.getSupportedDimensionValueRange().isSquareRootInput()) {
            return Math.sqrt(dimensionValue);
        }
        return dimensionValue;
    }

    public SupportedDimensionValueRange getSupportedDimensionValueRange() {
        return this.supportedDimensionValueRange;
    }

    @Override
    public int getNumberOfInputFeatures() {
        return 1;
    }

    @Override
    public int getNumberOfPossibleTargetValues() {
        throw new UnsupportedOperationException();
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.dimensionName == null ? 0 : this.dimensionName.hashCode());
        result = 31 * result + (this.supportedDimensionValueRange == null ? 0 : this.supportedDimensionValueRange.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        SingleDimensionBasedTwdTransitionRegressorModelContext other = (SingleDimensionBasedTwdTransitionRegressorModelContext)obj;
        if (this.dimensionName == null ? other.dimensionName != null : !this.dimensionName.equals(other.dimensionName)) {
            return false;
        }
        return !(this.supportedDimensionValueRange == null ? other.supportedDimensionValueRange != null : !this.supportedDimensionValueRange.equals(other.supportedDimensionValueRange));
    }

    @Override
    public String toString() {
        return String.valueOf(this.dimensionName) + "BasedTwdTransitionRegressorModelContext [dimensionName=" + this.dimensionName + ", supportedDimensionValueRange=" + this.supportedDimensionValueRange + "]";
    }

    @Override
    public String getId() {
        return String.valueOf(this.dimensionName) + "BasedTwdTransitionRegressor" + "From" + this.supportedDimensionValueRange.getFromInclusive() + "To" + (this.supportedDimensionValueRange.getToExclusive() >= 1.0E11 ? "Maximum" : Double.valueOf(this.supportedDimensionValueRange.getToExclusive()));
    }

    public boolean isDimensionValueSupported(double dimensionValue) {
        return this.supportedDimensionValueRange.getFromInclusive() <= dimensionValue && (this.supportedDimensionValueRange.getToExclusive() > dimensionValue || dimensionValue >= 1.0E11);
    }

    public boolean isDimensionValueSupportedForTraining(double dimensionValue) {
        return this.isDimensionValueSupported(dimensionValue) || this.supportedDimensionValueRange.getToExclusive() == dimensionValue;
    }

    @Override
    public boolean isContainsAllFeatures(TwdTransition instance) {
        double x = this.getDimensionValueUnpreprocessed(instance);
        return this.isDimensionValueSupported(x);
    }
}

