/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.windestimation.model.regressor.twdtransition;

import com.sap.sailing.windestimation.data.TwdTransition;
import com.sap.sailing.windestimation.model.regressor.twdtransition.DurationBasedTwdTransitionRegressorModelContext;
import com.sap.sailing.windestimation.model.regressor.twdtransition.SingleDimensionBasedTwdTransitionRegressorModelFactory;
import java.util.ArrayList;
import java.util.List;

public class DurationBasedTwdTransitionRegressorModelFactory
extends SingleDimensionBasedTwdTransitionRegressorModelFactory<DurationBasedTwdTransitionRegressorModelContext> {
    @Override
    public List<DurationBasedTwdTransitionRegressorModelContext> getAllCompatibleModelContexts(DurationBasedTwdTransitionRegressorModelContext modelContextWithMaxFeatures) {
        ArrayList<DurationBasedTwdTransitionRegressorModelContext> modelContexts = new ArrayList<DurationBasedTwdTransitionRegressorModelContext>();
        modelContexts.add(modelContextWithMaxFeatures);
        return modelContexts;
    }

    @Override
    public DurationBasedTwdTransitionRegressorModelContext createNewModelContext(TwdTransition twdTransition) {
        double secondsPassed = twdTransition.getDuration().asSeconds();
        DurationBasedTwdTransitionRegressorModelContext.DurationValueRange[] durationValueRangeArray = DurationBasedTwdTransitionRegressorModelContext.DurationValueRange.values();
        int n = durationValueRangeArray.length;
        int n2 = 0;
        while (n2 < n) {
            DurationBasedTwdTransitionRegressorModelContext.DurationValueRange durationValueRange = durationValueRangeArray[n2];
            DurationBasedTwdTransitionRegressorModelContext modelContext = new DurationBasedTwdTransitionRegressorModelContext(durationValueRange);
            if (modelContext.isDimensionValueSupported(secondsPassed)) {
                return modelContext;
            }
            ++n2;
        }
        throw new IllegalStateException("No DurationValueRange available for duration value of " + secondsPassed + " seconds");
    }
}

