/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.windestimation.model.regressor.twdtransition;

import com.sap.sailing.windestimation.data.TwdTransition;
import com.sap.sailing.windestimation.model.regressor.twdtransition.SingleDimensionBasedTwdTransitionRegressorModelContext;
import com.sap.sailing.windestimation.model.regressor.twdtransition.SupportedDimensionValueRange;
import com.sap.sailing.windestimation.model.store.ModelDomainType;

public final class DurationBasedTwdTransitionRegressorModelContext
extends SingleDimensionBasedTwdTransitionRegressorModelContext {
    private static final String DIMENSION_NAME = "Duration";
    private static final long serialVersionUID = 4324543543L;

    public DurationBasedTwdTransitionRegressorModelContext(DurationValueRange durationValueRange) {
        super(DIMENSION_NAME, ModelDomainType.DURATION_BASED_TWD_DELTA_STD_REGRESSOR, durationValueRange.getSupportedDimensionValueRange());
    }

    @Override
    public double getDimensionValueUnpreprocessed(TwdTransition instance) {
        double seconds = instance.getDuration().asSeconds();
        return seconds;
    }

    public static enum DurationValueRange {
        BEGINNING(0.0, 1.0, 1, false),
        MIDDLE1(1.0, 140.0, -1, true),
        MIDDLE2(140.0, 5394.0, 1, true),
        REMAINDER(5394.0, 1.0E11, 1, true);

        private final SupportedDimensionValueRange supportedDimensionValueRange;

        private DurationValueRange(double fromInclusive, double toExclusive, int polynomialDegree, boolean withBias) {
            this.supportedDimensionValueRange = new SupportedDimensionValueRange(fromInclusive, toExclusive, polynomialDegree, withBias);
        }

        public SupportedDimensionValueRange getSupportedDimensionValueRange() {
            return this.supportedDimensionValueRange;
        }
    }
}

