/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.windestimation.model.regressor;

import com.sap.sailing.domain.common.polars.NotEnoughDataHasBeenAddedException;
import com.sap.sailing.polars.regression.IncrementalLeastSquares;
import com.sap.sailing.polars.regression.impl.IncrementalAnyOrderLeastSquaresImpl;
import com.sap.sailing.windestimation.model.ModelContext;
import com.sap.sailing.windestimation.model.exception.ModelOperationException;
import com.sap.sailing.windestimation.model.regressor.AbstractRegressorModel;
import com.sap.sailing.windestimation.model.regressor.IncrementallyTrainableRegressorModel;
import org.apache.commons.math.analysis.polynomials.PolynomialFunction;

public class IncrementalSingleDimensionPolynomialRegressor<InstanceType, MC extends ModelContext<InstanceType>>
extends AbstractRegressorModel<InstanceType, MC>
implements IncrementallyTrainableRegressorModel<InstanceType, MC> {
    private static final long serialVersionUID = 2275631213670766824L;
    private final IncrementalLeastSquares regression;

    public IncrementalSingleDimensionPolynomialRegressor(MC modelContext, int polynomialOrder, boolean withBias) {
        super(modelContext);
        if (modelContext.getNumberOfInputFeatures() > 1) {
            throw new IllegalArgumentException("Only modelContext.getNumberOfInputFeatures() == 1 is supported");
        }
        this.regression = new IncrementalAnyOrderLeastSquaresImpl(polynomialOrder, withBias);
    }

    @Override
    public void train(double[] x, double y) {
        this.regression.addData(x[0], y);
    }

    @Override
    public double getValue(double[] x) {
        PolynomialFunction polynomialFunction;
        try {
            polynomialFunction = this.regression.getOrCreatePolynomialFunction();
        }
        catch (NotEnoughDataHasBeenAddedException e) {
            throw new ModelOperationException(e);
        }
        double value = polynomialFunction.value(x[0]);
        return value;
    }

    @Override
    public double getValue(double x) {
        PolynomialFunction polynomialFunction;
        try {
            polynomialFunction = this.regression.getOrCreatePolynomialFunction();
        }
        catch (NotEnoughDataHasBeenAddedException e) {
            throw new ModelOperationException(e);
        }
        double value = polynomialFunction.value(x);
        return value;
    }

    @Override
    public boolean isModelReady() {
        if (super.isModelReady()) {
            try {
                this.regression.getOrCreatePolynomialFunction();
            }
            catch (NotEnoughDataHasBeenAddedException e) {
                return false;
            }
            return true;
        }
        return false;
    }

    public String getPolynomAsString() {
        try {
            PolynomialFunction polynomialFunction = this.regression.getOrCreatePolynomialFunction();
            return polynomialFunction.toString();
        }
        catch (NotEnoughDataHasBeenAddedException e) {
            throw new ModelOperationException(e);
        }
    }
}

