/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.windestimation.model.classifier.smile;

import com.sap.sailing.windestimation.model.ModelContext;
import com.sap.sailing.windestimation.model.classifier.AbstractClassificationModel;
import com.sap.sailing.windestimation.model.classifier.PreprocessingConfig;
import smile.classification.SoftClassifier;
import smile.feature.Standardizer;
import smile.projection.PCA;

public abstract class AbstractSmileClassificationModel<InstanceType, MC extends ModelContext<InstanceType>>
extends AbstractClassificationModel<InstanceType, MC> {
    private static final long serialVersionUID = 1037686504611915506L;
    private Standardizer scaler = null;
    private PCA pca = null;
    protected SoftClassifier<double[]> internalModel = null;

    public AbstractSmileClassificationModel(PreprocessingConfig preprocessingConfig, MC modelContext) {
        super(preprocessingConfig, modelContext);
    }

    @Override
    public void train(double[][] x, int[] y) {
        this.resetTrainingStats();
        PreprocessingConfig preprocessingConfig = this.getPreprocessingConfig();
        this.scaler = null;
        if (preprocessingConfig.isScaling()) {
            this.scaler = new Standardizer(false);
            this.scaler.learn(x);
            x = this.scaler.transform(x);
        }
        this.pca = null;
        if (preprocessingConfig.isPca()) {
            this.pca = new PCA(x);
            if (preprocessingConfig.isPcaComponents()) {
                this.pca.setProjection(preprocessingConfig.getNumberOfPcaComponents());
            } else if (preprocessingConfig.isPcaPercentage()) {
                this.pca.setProjection(preprocessingConfig.getPercentageValue());
            }
            x = this.pca.project(x);
        }
        this.internalModel = this.trainInternalModel(x, y);
        this.setModelAsReadyAfterSuccessfulTraining();
    }

    protected abstract SoftClassifier<double[]> trainInternalModel(double[][] var1, int[] var2);

    @Override
    public double[] classifyWithProbabilities(double[] x) {
        x = this.preprocessX(x);
        double[] likelihoods = new double[((ModelContext)this.getModelContext()).getNumberOfPossibleTargetValues()];
        this.internalModel.predict((Object)x, likelihoods);
        return likelihoods;
    }

    protected double[] preprocessX(double[] x) {
        if (!this.isModelReady()) {
            throw new IllegalStateException("The classification model is not trained");
        }
        if (this.scaler != null) {
            x = this.scaler.transform(x);
        }
        if (this.pca != null) {
            x = this.pca.project(x);
        }
        return x;
    }
}

