/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.windestimation.model.classifier.maneuver;

import com.sap.sailing.windestimation.aggregator.hmm.ProbabilityUtil;
import com.sap.sailing.windestimation.data.ManeuverForEstimation;
import com.sap.sailing.windestimation.data.ManeuverTypeForClassification;

public class ManeuverWithProbabilisticTypeClassification
implements Comparable<ManeuverWithProbabilisticTypeClassification> {
    private final double[] likelihoodPerManeuverType;
    private final ManeuverForEstimation maneuver;

    public ManeuverWithProbabilisticTypeClassification(ManeuverForEstimation maneuver, double[] likelihoodPerManeuverType) {
        this.maneuver = maneuver;
        int i = 0;
        while (i < likelihoodPerManeuverType.length) {
            int n = i++;
            likelihoodPerManeuverType[n] = likelihoodPerManeuverType[n] + 0.05;
        }
        ProbabilityUtil.normalizeLikelihoodArray(likelihoodPerManeuverType);
        this.likelihoodPerManeuverType = likelihoodPerManeuverType;
    }

    public ManeuverForEstimation getManeuver() {
        return this.maneuver;
    }

    public double getManeuverTypeLikelihood(ManeuverTypeForClassification maneuverType) {
        return this.likelihoodPerManeuverType[maneuverType.ordinal()];
    }

    @Override
    public int compareTo(ManeuverWithProbabilisticTypeClassification o) {
        return this.maneuver.compareTo(o.maneuver);
    }

    public String toString() {
        StringBuilder result = new StringBuilder();
        result.append("probabilities: ");
        ManeuverTypeForClassification[] maneuverTypeForClassificationArray = ManeuverTypeForClassification.values();
        int n = maneuverTypeForClassificationArray.length;
        int n2 = 0;
        while (n2 < n) {
            ManeuverTypeForClassification type = maneuverTypeForClassificationArray[n2];
            result.append((Object)type);
            result.append(": ");
            result.append(this.getManeuverTypeLikelihood(type));
            result.append(", ");
            ++n2;
        }
        return result.substring(0, result.length() - 2);
    }
}

