/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.windestimation.model.classifier.maneuver;

import com.sap.sailing.windestimation.data.ManeuverForEstimation;
import com.sap.sailing.windestimation.data.ManeuverTypeForClassification;
import com.sap.sailing.windestimation.model.classifier.ClassifierModelFactory;
import com.sap.sailing.windestimation.model.classifier.TrainableClassificationModel;
import com.sap.sailing.windestimation.model.classifier.maneuver.ManeuverClassifierModelContext;
import com.sap.sailing.windestimation.model.classifier.maneuver.ManeuverFeatures;
import com.sap.sailing.windestimation.model.classifier.smile.NeuralNetworkClassifier;
import java.util.ArrayList;
import java.util.List;

public class ManeuverClassifierModelFactory
implements ClassifierModelFactory<ManeuverForEstimation, ManeuverClassifierModelContext> {
    public static final ManeuverTypeForClassification[] orderedSupportedTargetValues = new ManeuverTypeForClassification[]{ManeuverTypeForClassification.TACK, ManeuverTypeForClassification.JIBE};

    @Override
    public TrainableClassificationModel<ManeuverForEstimation, ManeuverClassifierModelContext> getNewModel(ManeuverClassifierModelContext modelContext) {
        NeuralNetworkClassifier<ManeuverForEstimation, ManeuverClassifierModelContext> classificationModel = new NeuralNetworkClassifier<ManeuverForEstimation, ManeuverClassifierModelContext>(modelContext);
        return classificationModel;
    }

    private static ManeuverClassifierModelContext createModelContext(ManeuverFeatures maneuverFeatures, String boatClassName) {
        ManeuverClassifierModelContext modelContext = new ManeuverClassifierModelContext(maneuverFeatures, boatClassName, orderedSupportedTargetValues);
        return modelContext;
    }

    @Override
    public List<ManeuverClassifierModelContext> getAllCompatibleModelContexts(ManeuverClassifierModelContext modelContextWithMaxFeatures) {
        ManeuverFeatures maneuverFeatures = modelContextWithMaxFeatures.getManeuverFeatures();
        String boatClassName = modelContextWithMaxFeatures.getBoatClassName();
        ArrayList<ManeuverClassifierModelContext> modelContextCandidates = new ArrayList<ManeuverClassifierModelContext>();
        ManeuverFeatures[] maneuverFeaturesArray = ManeuverFeatures.values();
        int n = maneuverFeaturesArray.length;
        int n2 = 0;
        while (n2 < n) {
            ManeuverFeatures possibleFeatures = maneuverFeaturesArray[n2];
            if (possibleFeatures.isSubset(maneuverFeatures)) {
                ManeuverClassifierModelContext modelContext = ManeuverClassifierModelFactory.createModelContext(possibleFeatures, null);
                modelContextCandidates.add(modelContext);
                if (boatClassName != null) {
                    ManeuverClassifierModelContext modelContextWithBoatClass = ManeuverClassifierModelFactory.createModelContext(possibleFeatures, boatClassName);
                    modelContextCandidates.add(modelContextWithBoatClass);
                }
            }
            ++n2;
        }
        return modelContextCandidates;
    }

    @Override
    public ManeuverClassifierModelContext getModelContextWhichModelAreAlwaysPresent() {
        return new ManeuverClassifierModelContext(new ManeuverFeatures(false, false, false), null, orderedSupportedTargetValues);
    }
}

