/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.windestimation.model.classifier.maneuver;

import com.sap.sailing.windestimation.aggregator.hmm.ProbabilityUtil;
import com.sap.sailing.windestimation.data.ManeuverForEstimation;
import com.sap.sailing.windestimation.data.ManeuverTypeForClassification;
import com.sap.sailing.windestimation.model.ModelContext;
import com.sap.sailing.windestimation.model.classifier.maneuver.ManeuverFeatures;
import com.sap.sailing.windestimation.model.store.ModelDomainType;
import java.util.Arrays;

public final class ManeuverClassifierModelContext
extends ModelContext<ManeuverForEstimation> {
    private static final long serialVersionUID = -7074647974723150672L;
    private final ManeuverFeatures maneuverFeatures;
    private final String boatClassName;
    protected final int[] indexToManeuverTypeOrdinalMapping;
    private final int numberOfSupportedManeuverTypes;
    private final int numberOfOtherTypes;

    public ManeuverClassifierModelContext(ManeuverFeatures maneuverFeatures, String boatClassName, ManeuverTypeForClassification ... orderedSupportedTargetValues) {
        super(ModelDomainType.MANEUVER_CLASSIFIER);
        this.maneuverFeatures = maneuverFeatures;
        this.boatClassName = boatClassName;
        this.indexToManeuverTypeOrdinalMapping = new int[ManeuverTypeForClassification.values().length];
        int i = 0;
        while (i < this.indexToManeuverTypeOrdinalMapping.length) {
            this.indexToManeuverTypeOrdinalMapping[i] = -1;
            ++i;
        }
        i = 0;
        ManeuverTypeForClassification[] maneuverTypeForClassificationArray = orderedSupportedTargetValues;
        int n = orderedSupportedTargetValues.length;
        int n2 = 0;
        while (n2 < n) {
            ManeuverTypeForClassification supportedManeuverType = maneuverTypeForClassificationArray[n2];
            this.indexToManeuverTypeOrdinalMapping[supportedManeuverType.ordinal()] = i++;
            ++n2;
        }
        int numberOfOtherTypes = 0;
        int j = 0;
        while (j < this.indexToManeuverTypeOrdinalMapping.length) {
            if (this.indexToManeuverTypeOrdinalMapping[j] == -1) {
                this.indexToManeuverTypeOrdinalMapping[j] = i;
                ++numberOfOtherTypes;
            }
            ++j;
        }
        this.numberOfOtherTypes = numberOfOtherTypes;
        this.numberOfSupportedManeuverTypes = i + (numberOfOtherTypes > 0 ? 1 : 0);
    }

    public ManeuverFeatures getManeuverFeatures() {
        return this.maneuverFeatures;
    }

    public String getBoatClassName() {
        return this.boatClassName;
    }

    @Override
    public int getNumberOfPossibleTargetValues() {
        return this.numberOfSupportedManeuverTypes;
    }

    public double[] getLikelihoodsPerManeuverTypeOrdinal(double[] likelihoodsFromModel) {
        double[] likelihoodsPerManeuverTypes = new double[ManeuverTypeForClassification.values().length];
        int j = 0;
        while (j < this.indexToManeuverTypeOrdinalMapping.length) {
            int mappedI = this.indexToManeuverTypeOrdinalMapping[j];
            likelihoodsPerManeuverTypes[j] = likelihoodsFromModel[mappedI];
            ++j;
        }
        if (this.numberOfOtherTypes > 1) {
            ProbabilityUtil.normalizeLikelihoodArray(likelihoodsPerManeuverTypes);
        }
        return likelihoodsPerManeuverTypes;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.boatClassName == null ? 0 : this.boatClassName.hashCode());
        result = 31 * result + Arrays.hashCode(this.indexToManeuverTypeOrdinalMapping);
        result = 31 * result + (this.maneuverFeatures == null ? 0 : this.maneuverFeatures.hashCode());
        result = 31 * result + this.numberOfSupportedManeuverTypes;
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        ManeuverClassifierModelContext other = (ManeuverClassifierModelContext)obj;
        if (this.boatClassName == null ? other.boatClassName != null : !this.boatClassName.equals(other.boatClassName)) {
            return false;
        }
        if (!Arrays.equals(this.indexToManeuverTypeOrdinalMapping, other.indexToManeuverTypeOrdinalMapping)) {
            return false;
        }
        if (this.maneuverFeatures == null ? other.maneuverFeatures != null : !this.maneuverFeatures.equals(other.maneuverFeatures)) {
            return false;
        }
        return this.numberOfSupportedManeuverTypes == other.numberOfSupportedManeuverTypes;
    }

    @Override
    public String toString() {
        return "ManeuverClassifierModelContext [maneuverFeatures=" + this.maneuverFeatures + ", boatClass=" + this.boatClassName + ", indexToManeuverTypeOrdinalMapping=" + Arrays.toString(this.indexToManeuverTypeOrdinalMapping) + ", numberOfSupportedManeuverTypes=" + this.numberOfSupportedManeuverTypes + "]";
    }

    public ManeuverTypeForClassification getManeuverTypeByMappingIndex(int likelihoodIndex) {
        ManeuverTypeForClassification[] maneuverTypeForClassificationArray = ManeuverTypeForClassification.values();
        int n = maneuverTypeForClassificationArray.length;
        int n2 = 0;
        while (n2 < n) {
            ManeuverTypeForClassification maneuverType = maneuverTypeForClassificationArray[n2];
            if (this.indexToManeuverTypeOrdinalMapping[maneuverType.ordinal()] == likelihoodIndex) {
                return maneuverType;
            }
            ++n2;
        }
        return null;
    }

    public int getOtherTypes() {
        return this.numberOfOtherTypes;
    }

    @Override
    public double[] getX(ManeuverForEstimation maneuver) {
        double[] inputVector = new double[this.getNumberOfInputFeatures()];
        int i = 0;
        inputVector[i++] = Math.abs(maneuver.getCourseChangeInDegrees());
        inputVector[i++] = maneuver.getSpeedLossRatio();
        inputVector[i++] = maneuver.getLowestSpeedVsExitingSpeedRatio();
        inputVector[i++] = maneuver.getSpeedGainRatio();
        inputVector[i++] = maneuver.getMaxTurningRateInDegreesPerSecond();
        if (this.maneuverFeatures.isPolarsInformation()) {
            inputVector[i++] = maneuver.getDeviationFromOptimalTackAngleInDegrees();
            inputVector[i++] = maneuver.getDeviationFromOptimalJibeAngleInDegrees();
        }
        if (this.maneuverFeatures.isScaledSpeed()) {
            inputVector[i++] = maneuver.getScaledSpeedBefore();
            inputVector[i++] = maneuver.getScaledSpeedAfter();
        }
        if (this.maneuverFeatures.isMarksInformation()) {
            inputVector[i++] = maneuver.isMarkPassing() ? 1.0 : 0.0;
        }
        return inputVector;
    }

    @Override
    public int getNumberOfInputFeatures() {
        int numberOfFeatures = 5;
        if (this.maneuverFeatures.isPolarsInformation()) {
            numberOfFeatures += 2;
        }
        if (this.maneuverFeatures.isScaledSpeed()) {
            numberOfFeatures += 2;
        }
        if (this.maneuverFeatures.isMarksInformation()) {
            ++numberOfFeatures;
        }
        return numberOfFeatures;
    }

    @Override
    public boolean isContainsAllFeatures(ManeuverForEstimation maneuver) {
        if (this.maneuverFeatures.isPolarsInformation() && (maneuver.getDeviationFromOptimalJibeAngleInDegrees() == null || maneuver.getDeviationFromOptimalTackAngleInDegrees() == null)) {
            return false;
        }
        if (this.maneuverFeatures.isMarksInformation() && !maneuver.isMarkPassingDataAvailable()) {
            return false;
        }
        return this.boatClassName == null || maneuver.getBoatClass() == null || this.boatClassName.equals(maneuver.getBoatClass().getName());
    }

    @Override
    public String getId() {
        StringBuilder id = new StringBuilder("ManeuverClassification-");
        id.append(this.getManeuverFeatures().toString());
        id.append("-");
        if (this.getBoatClassName() == null) {
            id.append("All");
        } else {
            id.append(this.getBoatClassName());
        }
        return id.toString();
    }
}

