/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.windestimation.integration;

import com.sap.sailing.domain.base.Competitor;
import com.sap.sailing.domain.common.Position;
import com.sap.sailing.domain.common.Wind;
import com.sap.sailing.domain.common.WindSource;
import com.sap.sailing.domain.common.WindSourceType;
import com.sap.sailing.domain.maneuverdetection.TrackTimeInfo;
import com.sap.sailing.domain.polars.PolarDataService;
import com.sap.sailing.domain.tracking.CompleteManeuverCurve;
import com.sap.sailing.domain.tracking.TrackedRace;
import com.sap.sailing.domain.tracking.WindTrack;
import com.sap.sailing.domain.tracking.WindWithConfidence;
import com.sap.sailing.domain.windestimation.IncrementalWindEstimation;
import com.sap.sailing.domain.windestimation.TimePointAndPositionWithToleranceComparator;
import com.sap.sailing.domain.windestimation.WindTrackWithConfidenceForEachWindFixImpl;
import com.sap.sailing.windestimation.aggregator.hmm.GraphLevelInference;
import com.sap.sailing.windestimation.aggregator.msthmm.DistanceAndDurationAwareWindTransitionProbabilitiesCalculator;
import com.sap.sailing.windestimation.aggregator.msthmm.MstBestPathsCalculator;
import com.sap.sailing.windestimation.aggregator.msthmm.MstBestPathsCalculatorImpl;
import com.sap.sailing.windestimation.aggregator.msthmm.MstGraphLevel;
import com.sap.sailing.windestimation.aggregator.msthmm.MstManeuverGraphGenerator;
import com.sap.sailing.windestimation.data.ManeuverWithEstimatedType;
import com.sap.sailing.windestimation.integration.CompleteManeuverCurveToManeuverForEstimationConverter;
import com.sap.sailing.windestimation.integration.IncrementalMstManeuverGraphGenerator;
import com.sap.sailing.windestimation.model.classifier.maneuver.ManeuverClassifiersCache;
import com.sap.sailing.windestimation.model.regressor.twdtransition.GaussianBasedTwdTransitionDistributionCache;
import com.sap.sailing.windestimation.windinference.DummyBasedTwsCalculatorImpl;
import com.sap.sailing.windestimation.windinference.MiddleCourseBasedTwdCalculatorImpl;
import com.sap.sailing.windestimation.windinference.PolarsBasedTwsCalculatorImpl;
import com.sap.sailing.windestimation.windinference.WindTrackCalculator;
import com.sap.sailing.windestimation.windinference.WindTrackCalculatorImpl;
import com.sap.sse.common.TimePoint;
import com.sap.sse.common.Util;
import com.sap.sse.util.ThreadPoolUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.ConcurrentLinkedDeque;
import java.util.concurrent.Executor;
import java.util.logging.Logger;

public class IncrementalMstHmmWindEstimationForTrackedRace
implements IncrementalWindEstimation {
    private static final Logger logger = Logger.getLogger(IncrementalMstHmmWindEstimationForTrackedRace.class.getName());
    private static final double WIND_COURSE_TOLERANCE_IN_DEGREES_TO_IGNORE_FOR_REUSE = 1.0;
    private final IncrementalMstManeuverGraphGenerator mstManeuverGraphGenerator;
    private final MstBestPathsCalculator bestPathsCalculator;
    private final WindTrackCalculator windTrackCalculator;
    private final Map<Util.Pair<Position, TimePoint>, WindWithConfidence<Util.Pair<Position, TimePoint>>> windTrackWithConfidences = new TreeMap<Util.Pair<Position, TimePoint>, WindWithConfidence<Util.Pair<Position, TimePoint>>>((Comparator<Util.Pair<Position, TimePoint>>)new TimePointAndPositionWithToleranceComparator());
    private final TrackedRace trackedRace;
    private final WindSource windSource;
    private final WindTrackWithConfidenceForEachWindFixImpl estimatedWindTrack;
    private static final Executor recalculator = ThreadPoolUtil.INSTANCE.getDefaultBackgroundTaskThreadPoolExecutor();
    private final ConcurrentLinkedDeque<Util.Triple<Competitor, Iterable<CompleteManeuverCurve>, TrackTimeInfo>> updateQueue;
    private GraphRecalculationTask updateTask;

    public IncrementalMstHmmWindEstimationForTrackedRace(TrackedRace trackedRace, WindSource windSource, PolarDataService polarDataService, long millisecondsOverWhichToAverage, ManeuverClassifiersCache maneuverClassifiersCache, GaussianBasedTwdTransitionDistributionCache gaussianBasedTwdTransitionDistributionCache) {
        this.estimatedWindTrack = new WindTrackWithConfidenceForEachWindFixImpl(millisecondsOverWhichToAverage, WindSourceType.MANEUVER_BASED_ESTIMATION.getBaseConfidence(), WindSourceType.MANEUVER_BASED_ESTIMATION.useSpeed() && polarDataService != null, String.valueOf(IncrementalMstHmmWindEstimationForTrackedRace.class.getSimpleName()) + " " + trackedRace.getRaceIdentifier(), false, this.windTrackWithConfidences);
        this.updateQueue = new ConcurrentLinkedDeque();
        this.trackedRace = trackedRace;
        this.windSource = windSource;
        DistanceAndDurationAwareWindTransitionProbabilitiesCalculator transitionProbabilitiesCalculator = new DistanceAndDurationAwareWindTransitionProbabilitiesCalculator(gaussianBasedTwdTransitionDistributionCache, true);
        this.mstManeuverGraphGenerator = new IncrementalMstManeuverGraphGenerator(new CompleteManeuverCurveToManeuverForEstimationConverter(trackedRace, polarDataService), transitionProbabilitiesCalculator, maneuverClassifiersCache);
        this.bestPathsCalculator = new MstBestPathsCalculatorImpl(transitionProbabilitiesCalculator);
        this.windTrackCalculator = new WindTrackCalculatorImpl(new MiddleCourseBasedTwdCalculatorImpl(), polarDataService == null ? new DummyBasedTwsCalculatorImpl() : new PolarsBasedTwsCalculatorImpl(polarDataService));
    }

    public WindTrack getWindTrack() {
        return this.estimatedWindTrack;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void waitUntilDone() throws InterruptedException {
        IncrementalMstHmmWindEstimationForTrackedRace incrementalMstHmmWindEstimationForTrackedRace = this;
        synchronized (incrementalMstHmmWindEstimationForTrackedRace) {
            while (this.updateTask != null) {
                this.wait();
            }
        }
    }

    public synchronized void newManeuverSpotsDetected(Competitor competitor, Iterable<CompleteManeuverCurve> newManeuvers, TrackTimeInfo trackTimeInfo) {
        boolean queueWasEmpty = this.updateQueue.isEmpty();
        this.updateQueue.add((Util.Triple<Competitor, Iterable<CompleteManeuverCurve>, TrackTimeInfo>)new Util.Triple((Object)competitor, newManeuvers, (Object)trackTimeInfo));
        logger.fine(() -> "Currently " + this.updateQueue.size() + " update jobs enqueued for race " + this.trackedRace.getRaceIdentifier());
        if (queueWasEmpty && this.updateTask == null) {
            logger.fine(() -> "Creating a new recalculation task for " + this.trackedRace.getRaceIdentifier());
            this.updateTask = new GraphRecalculationTask();
            this.notifyAll();
            recalculator.execute(this.updateTask);
        }
    }

    private boolean isWindNearlySame(Wind oneWind, Wind otherWind) {
        double bearingInDegrees = oneWind.getBearing().getDifferenceTo(otherWind.getBearing()).abs().getDegrees();
        return !(bearingInDegrees > 1.0);
    }

    public WindSource getWindSource() {
        return this.windSource;
    }

    private class GraphRecalculationTask
    implements Runnable {
        private GraphRecalculationTask() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            Util.Triple nextUpdate;
            logger.fine(() -> "This is a new recalculation task for " + IncrementalMstHmmWindEstimationForTrackedRace.this.trackedRace.getRaceIdentifier());
            do {
                IncrementalMstHmmWindEstimationForTrackedRace incrementalMstHmmWindEstimationForTrackedRace = IncrementalMstHmmWindEstimationForTrackedRace.this;
                synchronized (incrementalMstHmmWindEstimationForTrackedRace) {
                    nextUpdate = (Util.Triple)IncrementalMstHmmWindEstimationForTrackedRace.this.updateQueue.poll();
                    if (nextUpdate == null) {
                        logger.fine(() -> "No more updates enqueued for " + IncrementalMstHmmWindEstimationForTrackedRace.this.trackedRace.getRaceIdentifier() + "; terminating update task");
                        IncrementalMstHmmWindEstimationForTrackedRace.this.updateTask = null;
                        IncrementalMstHmmWindEstimationForTrackedRace.this.notifyAll();
                    }
                }
                if (nextUpdate == null) continue;
                logger.fine(() -> "Handling next update task for " + IncrementalMstHmmWindEstimationForTrackedRace.this.trackedRace.getRaceIdentifier() + "; still " + IncrementalMstHmmWindEstimationForTrackedRace.this.updateQueue.size() + " tasks in the queue");
                this.updateGraphGenerator((Competitor)nextUpdate.getA(), (Iterable)nextUpdate.getB(), (TrackTimeInfo)nextUpdate.getC());
            } while (nextUpdate != null);
        }

        private void updateGraphGenerator(Competitor competitor, Iterable<CompleteManeuverCurve> newManeuvers, TrackTimeInfo trackTimeInfo) {
            ArrayList<ManeuverWithEstimatedType> maneuversWithEstimatedType = new ArrayList<ManeuverWithEstimatedType>();
            for (CompleteManeuverCurve newManeuverSpot : newManeuvers) {
                IncrementalMstHmmWindEstimationForTrackedRace.this.mstManeuverGraphGenerator.add(competitor, newManeuverSpot, trackTimeInfo);
            }
            MstManeuverGraphGenerator.MstManeuverGraphComponents graphComponents = IncrementalMstHmmWindEstimationForTrackedRace.this.mstManeuverGraphGenerator.parseGraph();
            if (graphComponents != null) {
                Iterable<GraphLevelInference<MstGraphLevel>> bestPath = IncrementalMstHmmWindEstimationForTrackedRace.this.bestPathsCalculator.getBestNodes(graphComponents);
                for (GraphLevelInference<MstGraphLevel> inference : bestPath) {
                    ManeuverWithEstimatedType maneuverWithEstimatedType = new ManeuverWithEstimatedType(inference.getGraphLevel().getManeuver(), inference.getGraphNode().getManeuverType(), inference.getConfidence());
                    maneuversWithEstimatedType.add(maneuverWithEstimatedType);
                }
                Collections.sort(maneuversWithEstimatedType);
                List<WindWithConfidence<Util.Pair<Position, TimePoint>>> newWindTrack = IncrementalMstHmmWindEstimationForTrackedRace.this.windTrackCalculator.getWindTrackFromManeuverClassifications(maneuversWithEstimatedType);
                HashMap<Util.Pair, WindWithConfidence<Util.Pair<Position, TimePoint>>> newWindTrackMap = new HashMap<Util.Pair, WindWithConfidence<Util.Pair<Position, TimePoint>>>(newWindTrack.size());
                for (WindWithConfidence<Util.Pair<Position, TimePoint>> wind : newWindTrack) {
                    newWindTrackMap.put((Util.Pair)wind.getRelativeTo(), wind);
                }
                ArrayList<Object> windFixesToAdd = new ArrayList<Object>();
                IncrementalMstHmmWindEstimationForTrackedRace.this.estimatedWindTrack.lockForWrite();
                try {
                    Iterator iterator = IncrementalMstHmmWindEstimationForTrackedRace.this.windTrackWithConfidences.values().iterator();
                    while (iterator.hasNext()) {
                        WindWithConfidence previousWind = (WindWithConfidence)iterator.next();
                        WindWithConfidence newWind = (WindWithConfidence)newWindTrackMap.get(previousWind.getRelativeTo());
                        if (newWind == null) {
                            iterator.remove();
                            IncrementalMstHmmWindEstimationForTrackedRace.this.trackedRace.removeWind((Wind)previousWind.getObject(), IncrementalMstHmmWindEstimationForTrackedRace.this.windSource);
                            continue;
                        }
                        if (IncrementalMstHmmWindEstimationForTrackedRace.this.isWindNearlySame((Wind)newWind.getObject(), (Wind)previousWind.getObject())) continue;
                        iterator.remove();
                        IncrementalMstHmmWindEstimationForTrackedRace.this.trackedRace.removeWind((Wind)previousWind.getObject(), IncrementalMstHmmWindEstimationForTrackedRace.this.windSource);
                        windFixesToAdd.add(newWind);
                    }
                    for (WindWithConfidence<Util.Pair<Position, TimePoint>> windWithConfidence : newWindTrack) {
                        if (IncrementalMstHmmWindEstimationForTrackedRace.this.windTrackWithConfidences.containsKey(windWithConfidence.getRelativeTo())) continue;
                        windFixesToAdd.add(windWithConfidence);
                    }
                    for (WindWithConfidence windWithConfidence : windFixesToAdd) {
                        IncrementalMstHmmWindEstimationForTrackedRace.this.windTrackWithConfidences.put((Util.Pair)windWithConfidence.getRelativeTo(), windWithConfidence);
                        IncrementalMstHmmWindEstimationForTrackedRace.this.trackedRace.recordWind((Wind)windWithConfidence.getObject(), IncrementalMstHmmWindEstimationForTrackedRace.this.windSource, false);
                    }
                }
                finally {
                    IncrementalMstHmmWindEstimationForTrackedRace.this.estimatedWindTrack.unlockAfterWrite();
                }
            }
        }
    }
}

