/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.windestimation.aggregator.polarsfitting;

public class WindSpeedRange {
    private final double upperSpeed;
    private final double lowerSpeed;
    private final double confidence;

    public WindSpeedRange(double upperSpeed, double lowerSpeed) {
        this(upperSpeed, lowerSpeed, 1.0);
    }

    private WindSpeedRange(double upperSpeed, double lowerSpeed, double confidence) {
        this.upperSpeed = upperSpeed;
        this.lowerSpeed = lowerSpeed;
        this.confidence = confidence;
    }

    public double getUpperSpeed() {
        return this.upperSpeed;
    }

    public double getLowerSpeed() {
        return this.lowerSpeed;
    }

    public double getMiddleSpeed() {
        return (this.upperSpeed + this.lowerSpeed) / 2.0;
    }

    public double getSpeedDifference() {
        return this.upperSpeed - this.lowerSpeed;
    }

    public double getConfidence() {
        return this.confidence;
    }

    public double getDeviationOfSpeedFromRange(double speed) {
        double lowerSpeedDeviation = this.lowerSpeed - speed;
        double upperSpeedDeviation = speed - this.upperSpeed;
        if (lowerSpeedDeviation > 0.0 || upperSpeedDeviation > 0.0) {
            return Math.max(lowerSpeedDeviation, upperSpeedDeviation);
        }
        return 0.0;
    }

    public WindSpeedRange intersect(WindSpeedRange other) {
        double newUpperSpeed = Math.min(this.upperSpeed, other.upperSpeed);
        double newLowerSpeed = Math.max(this.lowerSpeed, other.lowerSpeed);
        double newConfidence = (this.confidence + other.confidence) / 2.0;
        if (newUpperSpeed < newLowerSpeed) {
            newConfidence *= 1.0 / (1.0 + (newLowerSpeed - newUpperSpeed) / 5.0);
            double temp = newLowerSpeed;
            newLowerSpeed = newUpperSpeed;
            newUpperSpeed = temp;
        }
        return new WindSpeedRange(newUpperSpeed, newLowerSpeed, newConfidence);
    }

    public WindSpeedRange extend(WindSpeedRange other) {
        double newUpperSpeed = Math.max(this.upperSpeed, other.upperSpeed);
        double newLowerSpeed = Math.min(this.lowerSpeed, other.lowerSpeed);
        double newConfidence = (this.confidence + other.confidence) / 2.0;
        return new WindSpeedRange(newUpperSpeed, newLowerSpeed, newConfidence);
    }
}

