/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.windestimation.aggregator.outlierremoval;

import com.sap.sailing.windestimation.data.ManeuverWithEstimatedType;
import java.util.ArrayList;
import java.util.List;

public class OutlierAnalysisResult {
    private final List<ManeuverWithEstimatedType> includedManeuvers = new ArrayList<ManeuverWithEstimatedType>();
    private final List<ManeuverWithEstimatedType> excludedManeuvers = new ArrayList<ManeuverWithEstimatedType>();
    private double sumOfConfidencesOfIncludedFixes = 0.0;
    private double sumOfConfidencesOfExcludedFixes = 0.0;

    public void addIncludedManeuver(ManeuverWithEstimatedType maneuverToInclude) {
        this.includedManeuvers.add(maneuverToInclude);
        this.sumOfConfidencesOfIncludedFixes += maneuverToInclude.getConfidence();
    }

    public void addExcludedManeuver(ManeuverWithEstimatedType maneuverToExclude) {
        this.excludedManeuvers.add(maneuverToExclude);
        this.sumOfConfidencesOfExcludedFixes += maneuverToExclude.getConfidence();
    }

    public List<ManeuverWithEstimatedType> getIncludedManeuvers() {
        return this.includedManeuvers;
    }

    public List<ManeuverWithEstimatedType> getExcludedManeuvers() {
        return this.excludedManeuvers;
    }

    public double getFinalConfidence() {
        double finalConfidence = this.sumOfConfidencesOfIncludedFixes / (this.sumOfConfidencesOfIncludedFixes + this.sumOfConfidencesOfExcludedFixes);
        return finalConfidence;
    }
}

