/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.windestimation.aggregator.msthmm;

import com.sap.sailing.windestimation.aggregator.graph.Tree;
import com.sap.sailing.windestimation.aggregator.msthmm.AbstractMstGraphGenerator;
import com.sap.sailing.windestimation.aggregator.msthmm.MstGraphLevel;
import com.sap.sailing.windestimation.aggregator.msthmm.MstGraphNodeTransitionProbabilitiesCalculator;
import com.sap.sailing.windestimation.model.classifier.maneuver.ManeuverWithProbabilisticTypeClassification;
import java.util.ArrayList;
import java.util.List;

public class MstManeuverGraphGenerator
extends AbstractMstGraphGenerator<ManeuverWithProbabilisticTypeClassification>
implements Cloneable {
    private final MstGraphNodeTransitionProbabilitiesCalculator transitionProbabilitiesCalculator;

    public MstManeuverGraphGenerator(MstGraphNodeTransitionProbabilitiesCalculator transitionProbabilitiesCalculator) {
        this.transitionProbabilitiesCalculator = transitionProbabilitiesCalculator;
    }

    protected MstManeuverGraphGenerator(List<AbstractMstGraphGenerator.NodeWithNeighbors<ManeuverWithProbabilisticTypeClassification>> nodes, MstGraphNodeTransitionProbabilitiesCalculator transitionProbabilitiesCalculator) {
        super(nodes);
        this.transitionProbabilitiesCalculator = transitionProbabilitiesCalculator;
    }

    @Override
    protected double getDistanceBetweenObservations(ManeuverWithProbabilisticTypeClassification o1, ManeuverWithProbabilisticTypeClassification o2) {
        double compoundDistance = this.transitionProbabilitiesCalculator.getCompoundDistance(o1.getManeuver(), o2.getManeuver());
        return compoundDistance;
    }

    public MstManeuverGraphComponents parseGraph() {
        List nodes = this.getNodes();
        if (nodes.isEmpty()) {
            return null;
        }
        ArrayList<MstGraphLevel> leaves = new ArrayList<MstGraphLevel>();
        AbstractMstGraphGenerator.NodeWithNeighbors<ManeuverWithProbabilisticTypeClassification> firstNode = nodes.get(0);
        MstGraphLevel firstGraphLevel = new MstGraphLevel((ManeuverWithProbabilisticTypeClassification)firstNode.getObservation(), this.transitionProbabilitiesCalculator);
        this.parseGraphFromNodes(firstNode, firstGraphLevel, null, leaves);
        MstManeuverGraphComponents graphComponents = new MstManeuverGraphComponents(firstGraphLevel, leaves);
        return graphComponents;
    }

    private void parseGraphFromNodes(AbstractMstGraphGenerator.NodeWithNeighbors<ManeuverWithProbabilisticTypeClassification> previousNode, MstGraphLevel previousGraphLevel, AbstractMstGraphGenerator.NodeWithNeighbors<ManeuverWithProbabilisticTypeClassification> parentOfPreviousNode, List<MstGraphLevel> leaves) {
        List<AbstractMstGraphGenerator.NodeWithDistance<ManeuverWithProbabilisticTypeClassification>> childNodes = previousNode.getNeighbors();
        if (childNodes.size() <= 1 && (childNodes.isEmpty() || parentOfPreviousNode != null)) {
            leaves.add(previousGraphLevel);
        } else {
            for (AbstractMstGraphGenerator.NodeWithDistance<ManeuverWithProbabilisticTypeClassification> childNodeWithDistance : childNodes) {
                AbstractMstGraphGenerator.NodeWithNeighbors<ManeuverWithProbabilisticTypeClassification> childNode = childNodeWithDistance.getNodeWithNeighbors();
                if (childNode == parentOfPreviousNode) continue;
                MstGraphLevel newGraphLevel = previousGraphLevel.addChild(childNodeWithDistance.getDistance(), childNode.getObservation(), this.transitionProbabilitiesCalculator);
                this.parseGraphFromNodes(childNode, newGraphLevel, previousNode, leaves);
            }
        }
    }

    public MstManeuverGraphGenerator clone() {
        return new MstManeuverGraphGenerator(this.getClonedNodes(), this.transitionProbabilitiesCalculator);
    }

    public static class MstManeuverGraphComponents
    implements Tree<MstGraphLevel> {
        private final MstGraphLevel root;
        private final List<MstGraphLevel> leaves;

        public MstManeuverGraphComponents(MstGraphLevel root, List<MstGraphLevel> leaves) {
            this.root = root;
            this.leaves = leaves;
        }

        @Override
        public MstGraphLevel getRoot() {
            return this.root;
        }

        public List<MstGraphLevel> getLeaves() {
            return this.leaves;
        }
    }
}

