/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.windestimation.aggregator.hmm;

import com.sap.sailing.windestimation.aggregator.hmm.GraphLevelBase;
import com.sap.sailing.windestimation.aggregator.hmm.GraphNode;
import com.sap.sailing.windestimation.aggregator.hmm.GraphNodeTransitionProbabilitiesCalculator;
import com.sap.sailing.windestimation.aggregator.hmm.IntersectedWindRange;
import com.sap.sailing.windestimation.aggregator.hmm.WindCourseRange;
import com.sap.sailing.windestimation.data.ManeuverForEstimation;
import com.sap.sailing.windestimation.data.ManeuverTypeForClassification;
import com.sap.sailing.windestimation.data.TwdTransition;
import com.sap.sse.common.Bearing;
import com.sap.sse.common.Distance;
import com.sap.sse.common.Duration;
import com.sap.sse.common.Util;
import com.sap.sse.common.impl.DegreeBearingImpl;

public class IntersectedWindRangeBasedTransitionProbabilitiesCalculator<GL extends GraphLevelBase<GL>>
implements GraphNodeTransitionProbabilitiesCalculator<GL> {
    private static final double LA_PLACE_TRANSITION_PROBABILITY = 0.001;
    protected static final int MIN_BEATING_ANGLE_PLUS_MIN_RUNNING_ANGLE = 40;
    private static final double MAX_ABS_WIND_COURSE_DEVIATION_TOLERANCE_WITHIN_ANALYSIS_INTERVAL_IN_DEGREES = 40.0;
    protected final boolean propagateIntersectedWindRangeOfHeadupAndBearAway;

    public IntersectedWindRangeBasedTransitionProbabilitiesCalculator(boolean propagateIntersectedWindRangeOfHeadupAndBearAway) {
        this.propagateIntersectedWindRangeOfHeadupAndBearAway = propagateIntersectedWindRangeOfHeadupAndBearAway;
    }

    @Override
    public Util.Pair<IntersectedWindRange, Double> mergeWindRangeAndGetTransitionProbability(GraphNode<GL> previousNode, GL previousLevel, IntersectedWindRange previousIntersectedWindRange, GraphNode<GL> currentNode, GL currentLevel) {
        Duration durationPassed = this.getDuration(((GraphLevelBase)previousLevel).getManeuver(), ((GraphLevelBase)currentLevel).getManeuver());
        Distance distancePassed = this.getDistance(((GraphLevelBase)previousLevel).getManeuver(), ((GraphLevelBase)currentLevel).getManeuver());
        double transitionProbabilitySum = 0.0;
        double transitionProbabilityUntilCurrentNode = -1.0;
        IntersectedWindRange intersectedWindRangeUntilCurrentNode = null;
        for (GraphNode node : ((GraphLevelBase)currentLevel).getLevelNodes()) {
            IntersectedWindRange intersectedWindRange = previousIntersectedWindRange.intersect(node.getValidWindRange(), WindCourseRange.CombinationModeOnViolation.INTERSECTION);
            TwdTransition twdTransition = this.constructTwdTransition(durationPassed, distancePassed, intersectedWindRange.getViolationRange(), previousNode.getManeuverType(), node.getManeuverType());
            double transitionProbability = this.getPenaltyFactorForTransition(twdTransition);
            transitionProbabilitySum += transitionProbability;
            if (node != currentNode) continue;
            transitionProbabilityUntilCurrentNode = transitionProbability;
            IntersectedWindRange intersectedWindRange2 = intersectedWindRangeUntilCurrentNode = this.propagateIntersectedWindRangeOfHeadupAndBearAway && (node.getManeuverType() == ManeuverTypeForClassification.BEAR_AWAY || node.getManeuverType() == ManeuverTypeForClassification.HEAD_UP) ? intersectedWindRange : node.getValidWindRange().toIntersected();
        }
        if (transitionProbabilityUntilCurrentNode < 0.0) {
            throw new IllegalArgumentException("currentNode not contained in currentLevel");
        }
        double normalizedTransitionProbabilityUntilCurrentNode = transitionProbabilityUntilCurrentNode / transitionProbabilitySum;
        return new Util.Pair(intersectedWindRangeUntilCurrentNode, (Object)normalizedTransitionProbabilityUntilCurrentNode);
    }

    protected double getPenaltyFactorForTransition(TwdTransition twdTransition) {
        double violationRange = twdTransition.getTwdChange().getDegrees();
        double penaltyFactor = violationRange == 0.0 ? 1.0 : (violationRange <= 40.0 ? 1.0 / (1.0 + Math.pow(violationRange / 40.0 * 2.0, 2.0)) : 1.0 / (1.0 + Math.pow(violationRange, 2.0)));
        return penaltyFactor + 0.001;
    }

    @Override
    public WindCourseRange getWindCourseRangeForManeuverType(ManeuverForEstimation maneuver, ManeuverTypeForClassification maneuverType) {
        switch (maneuverType) {
            case TACK: {
                return this.getTackWindRange(maneuver);
            }
            case JIBE: {
                return this.getJibeWindRange(maneuver);
            }
            case HEAD_UP: {
                return this.getHeadUpWindRange(maneuver);
            }
            case BEAR_AWAY: {
                return this.getBearAwayWindRange(maneuver);
            }
        }
        throw new IllegalArgumentException();
    }

    protected WindCourseRange getBearAwayWindRange(ManeuverForEstimation maneuver) {
        Bearing invertedCourseBefore = maneuver.getSpeedWithBearingBefore().getBearing().reverse();
        double angleTowardStarboard = invertedCourseBefore.getDifferenceTo(maneuver.getSpeedWithBearingAfter().getBearing()).abs().getDegrees();
        assert ((angleTowardStarboard -= 40.0) > 0.0);
        Bearing from = maneuver.getCourseChangeInDegrees() < 0.0 ? invertedCourseBefore.add((Bearing)new DegreeBearingImpl(40.0)) : maneuver.getSpeedWithBearingAfter().getBearing();
        WindCourseRange windRange = new WindCourseRange(from.getDegrees(), angleTowardStarboard);
        return windRange;
    }

    protected WindCourseRange getHeadUpWindRange(ManeuverForEstimation maneuver) {
        Bearing invertedCourseAfter = maneuver.getSpeedWithBearingAfter().getBearing().reverse();
        double angleTowardStarboard = invertedCourseAfter.getDifferenceTo(maneuver.getSpeedWithBearingBefore().getBearing()).abs().getDegrees();
        assert ((angleTowardStarboard -= 40.0) > 0.0);
        Bearing from = maneuver.getCourseChangeInDegrees() < 0.0 ? maneuver.getSpeedWithBearingBefore().getBearing() : invertedCourseAfter.add((Bearing)new DegreeBearingImpl(40.0));
        WindCourseRange windRange = new WindCourseRange(from.getDegrees(), angleTowardStarboard);
        return windRange;
    }

    protected WindCourseRange getJibeWindRange(ManeuverForEstimation maneuver) {
        double middleAngleRange;
        Bearing middleCourse = maneuver.getMiddleCourse();
        double absCourseChangeDeg = Math.abs(maneuver.getCourseChangeInDegrees());
        double d = middleAngleRange = maneuver.getDeviationFromOptimalJibeAngleInDegrees() == null ? absCourseChangeDeg * 0.2 : Math.abs(maneuver.getDeviationFromOptimalJibeAngleInDegrees());
        if (middleAngleRange < 10.0) {
            middleAngleRange = 10.0;
        }
        Bearing from = middleCourse.add((Bearing)new DegreeBearingImpl(-middleAngleRange / 2.0));
        WindCourseRange windRange = new WindCourseRange(from.getDegrees(), middleAngleRange);
        return windRange;
    }

    protected WindCourseRange getTackWindRange(ManeuverForEstimation maneuver) {
        Bearing middleCourse = maneuver.getMiddleCourse();
        double absCourseChangeDeg = Math.abs(maneuver.getCourseChangeInDegrees());
        double middleAngleRange = maneuver.getDeviationFromOptimalTackAngleInDegrees() == null ? absCourseChangeDeg * 0.1 : Math.abs(maneuver.getDeviationFromOptimalTackAngleInDegrees());
        Bearing from = middleCourse.add((Bearing)new DegreeBearingImpl(-middleAngleRange / 2.0));
        from = from.reverse();
        WindCourseRange windRange = new WindCourseRange(from.getDegrees(), middleAngleRange);
        return windRange;
    }

    protected TwdTransition constructTwdTransition(Duration durationPassed, Distance distancePassed, double twdChangeInDegrees, ManeuverTypeForClassification fromManeuverType, ManeuverTypeForClassification toManeuverType) {
        DegreeBearingImpl twdChange = new DegreeBearingImpl(twdChangeInDegrees);
        TwdTransition twdTransition = new TwdTransition(distancePassed, durationPassed, (Bearing)twdChange, fromManeuverType, toManeuverType);
        return twdTransition;
    }

    protected Distance getDistance(ManeuverForEstimation fromManeuver, ManeuverForEstimation toManeuver) {
        return fromManeuver.getManeuverPosition().getDistance(toManeuver.getManeuverPosition());
    }

    protected Duration getDuration(ManeuverForEstimation fromManeuver, ManeuverForEstimation toManeuver) {
        return fromManeuver.getManeuverTimePoint().until(toManeuver.getManeuverTimePoint()).abs();
    }

    @Override
    public boolean isPropagateIntersectedWindRangeOfHeadupAndBearAway() {
        return this.propagateIntersectedWindRangeOfHeadupAndBearAway;
    }
}

