/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sse.util.impl;

import com.sap.sse.common.Util;
import com.sap.sse.util.ThreadPoolUtil;
import com.sap.sse.util.impl.NamedTracingScheduledThreadPoolExecutor;
import com.sap.sse.util.impl.ThreadFactoryWithPriority;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.shiro.SecurityUtils;
import org.apache.shiro.UnavailableSecurityManagerException;
import org.apache.shiro.subject.Subject;

public class ThreadPoolUtilImpl
implements ThreadPoolUtil {
    private static final Logger logger = Logger.getLogger(ThreadPoolUtilImpl.class.getName());
    private static final int REASONABLE_THREAD_POOL_SIZE = Math.max(Runtime.getRuntime().availableProcessors() - 1, 3);
    private final ScheduledExecutorService defaultBackgroundTaskThreadPoolExecutor = this.createBackgroundTaskThreadPoolExecutor("Default background executor");
    private final ScheduledExecutorService defaultForegroundTaskThreadPoolExecutor = this.createForegroundTaskThreadPoolExecutor(2 * REASONABLE_THREAD_POOL_SIZE, "Default foreground executor");

    @Override
    public ScheduledExecutorService getDefaultBackgroundTaskThreadPoolExecutor() {
        return this.defaultBackgroundTaskThreadPoolExecutor;
    }

    @Override
    public ScheduledExecutorService getDefaultForegroundTaskThreadPoolExecutor() {
        return this.defaultForegroundTaskThreadPoolExecutor;
    }

    @Override
    public ScheduledExecutorService createBackgroundTaskThreadPoolExecutor(String name) {
        return this.createThreadPoolExecutor(name, 4);
    }

    @Override
    public ScheduledExecutorService createBackgroundTaskThreadPoolExecutor(int size, String name) {
        return this.createThreadPoolExecutor(name, 4, size, false);
    }

    @Override
    public ScheduledExecutorService createBackgroundTaskThreadPoolExecutor(int size, String name, boolean executeExistingDelayedTasksAfterShutdownPolicy) {
        return this.createThreadPoolExecutor(name, 4, size, executeExistingDelayedTasksAfterShutdownPolicy);
    }

    @Override
    public ScheduledExecutorService createForegroundTaskThreadPoolExecutor(String name) {
        return this.createThreadPoolExecutor(name, 5);
    }

    @Override
    public ScheduledExecutorService createForegroundTaskThreadPoolExecutor(int size, String name) {
        return this.createThreadPoolExecutor(name, 5, size, false);
    }

    private ScheduledExecutorService createThreadPoolExecutor(String name, int priority) {
        return this.createThreadPoolExecutor(name, priority, REASONABLE_THREAD_POOL_SIZE, false);
    }

    private ScheduledExecutorService createThreadPoolExecutor(String name, int priority, int size, boolean executeExistingDelayedTasksAfterShutdownPolicy) {
        NamedTracingScheduledThreadPoolExecutor result = new NamedTracingScheduledThreadPoolExecutor(name, size, new ThreadFactoryWithPriority(name, priority, true));
        result.setExecuteExistingDelayedTasksAfterShutdownPolicy(false);
        return result;
    }

    @Override
    public int getReasonableThreadPoolSize() {
        return REASONABLE_THREAD_POOL_SIZE;
    }

    @Override
    public void logExceptionsFromFutures(Level logLevel, String messageTemplate, Iterable<? extends Future<?>> futures) {
        for (Future<?> result : futures) {
            try {
                result.get();
            }
            catch (ExecutionException e) {
                Throwable t = e.getCause();
                logger.log(logLevel, String.format(messageTemplate, t.getMessage()), t);
            }
            catch (InterruptedException e) {
                logger.log(logLevel, String.format(messageTemplate, e.getMessage()), e);
            }
        }
    }

    @Override
    public <T> List<Future<T>> invokeAllAndLogExceptions(ExecutorService executor, Level logLevel, String messageTemplate, Iterable<? extends Callable<T>> tasks) {
        ArrayList tasksAsList = new ArrayList();
        Util.addAll(tasks, tasksAsList);
        List result = null;
        try {
            result = executor.invokeAll(tasksAsList);
            this.logExceptionsFromFutures(logLevel, messageTemplate, result);
        }
        catch (InterruptedException e) {
            logger.log(logLevel, String.format(messageTemplate, e.getMessage()), e);
        }
        return result;
    }

    private Optional<Subject> getSubjectOrNull() {
        Optional<Object> mySubject;
        try {
            mySubject = Optional.ofNullable(SecurityUtils.getSubject());
        }
        catch (IllegalStateException | UnavailableSecurityManagerException e) {
            mySubject = Optional.empty();
        }
        return mySubject;
    }

    @Override
    public Runnable associateWithSubjectIfAny(Runnable runnable) {
        return this.getSubjectOrNull().map(subject -> subject.associateWith(runnable)).orElse(runnable);
    }

    @Override
    public <T> Callable<T> associateWithSubjectIfAny(Callable<T> callable) {
        return this.getSubjectOrNull().map(subject -> subject.associateWith(callable)).orElse(callable);
    }
}

