/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sse.util.impl;

import com.sap.sse.util.ThreadPoolUtil;
import com.sap.sse.util.impl.KnowsExecutor;
import com.sap.sse.util.impl.KnowsExecutorAndTracingGet;
import com.sap.sse.util.impl.KnowsExecutorAndTracingGetImpl;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.FutureTask;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ThreadPoolAwareFutureTask<V>
extends FutureTask<V>
implements KnowsExecutor {
    private static final Logger logger = Logger.getLogger(ThreadPoolAwareFutureTask.class.getName());
    private final KnowsExecutorAndTracingGet<V> getHelper = new KnowsExecutorAndTracingGetImpl();
    private final Object callableOrRunnableIfLoggingFine;
    private final Object delegate;

    public ThreadPoolAwareFutureTask(ThreadPoolExecutor executor, Callable<V> callable) {
        super(ThreadPoolUtil.INSTANCE.associateWithSubjectIfAny(callable));
        this.delegate = callable;
        this.callableOrRunnableIfLoggingFine = logger.isLoggable(Level.FINE) ? callable : null;
        this.setExecutorThisTaskIsScheduledFor(executor);
    }

    public ThreadPoolAwareFutureTask(ThreadPoolExecutor executor, Runnable runnable, V result) {
        super(ThreadPoolUtil.INSTANCE.associateWithSubjectIfAny(runnable), result);
        this.delegate = runnable;
        this.callableOrRunnableIfLoggingFine = logger.isLoggable(Level.FINE) ? runnable : null;
        this.setExecutorThisTaskIsScheduledFor(executor);
    }

    @Override
    public void run() {
        super.run();
    }

    @Override
    public void setExecutorThisTaskIsScheduledFor(ThreadPoolExecutor executorThisTaskIsScheduledFor) {
        if (this.delegate instanceof KnowsExecutor) {
            ((KnowsExecutor)this.delegate).setExecutorThisTaskIsScheduledFor(executorThisTaskIsScheduledFor);
        }
        this.getHelper.setExecutorThisTaskIsScheduledFor(executorThisTaskIsScheduledFor);
    }

    @Override
    public V get() throws InterruptedException, ExecutionException {
        return this.getHelper.callGetAndTraceAfterEachTimeout(this);
    }

    @Override
    public String toString() {
        return String.valueOf(super.toString()) + (this.callableOrRunnableIfLoggingFine == null ? "" : " " + this.callableOrRunnableIfLoggingFine.toString());
    }
}

