/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sse.util.impl;

import com.sap.sse.common.Duration;
import com.sap.sse.common.Named;
import com.sap.sse.common.TimePoint;
import com.sap.sse.common.impl.MillisecondsTimePoint;
import com.sap.sse.concurrent.ConcurrentWeakHashMap;
import com.sap.sse.util.impl.KnowsExecutor;
import com.sap.sse.util.impl.ThreadPoolAwareFutureTask;
import com.sap.sse.util.impl.ThreadPoolAwareRunnableScheduledFutureDelegate;
import com.sap.sse.util.impl.ThreadPoolMXBeanImpl;
import java.lang.management.ManagementFactory;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.RunnableFuture;
import java.util.concurrent.RunnableScheduledFuture;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.management.InstanceAlreadyExistsException;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanRegistrationException;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.NotCompliantMBeanException;
import javax.management.ObjectName;

public class NamedTracingScheduledThreadPoolExecutor
extends ScheduledThreadPoolExecutor
implements Named {
    private static final long serialVersionUID = 211715492525163730L;
    private static final Logger logger = Logger.getLogger(NamedTracingScheduledThreadPoolExecutor.class.getName());
    private final String name;
    private final ConcurrentHashMap<Runnable, TimePoint> startTimePoints = new ConcurrentHashMap();
    private final ConcurrentWeakHashMap<ScheduledFuture<?>, Runnable> wrappedRunnables = new ConcurrentWeakHashMap();
    private final Duration DURATION_LOGGING_THRESHOLD = Duration.ONE_SECOND.times(5L);

    public NamedTracingScheduledThreadPoolExecutor(String name, int corePoolSize, RejectedExecutionHandler handler) {
        super(corePoolSize, handler);
        this.name = name;
        this.tryToRegisterMBeanForThreadPool();
    }

    public NamedTracingScheduledThreadPoolExecutor(String name, int corePoolSize, ThreadFactory threadFactory, RejectedExecutionHandler handler) {
        super(corePoolSize, threadFactory, handler);
        this.name = name;
        this.tryToRegisterMBeanForThreadPool();
    }

    public NamedTracingScheduledThreadPoolExecutor(String name, int corePoolSize, ThreadFactory threadFactory) {
        super(corePoolSize, threadFactory);
        this.name = name;
        this.tryToRegisterMBeanForThreadPool();
    }

    public NamedTracingScheduledThreadPoolExecutor(String name, int corePoolSize) {
        super(corePoolSize);
        this.name = name;
        this.tryToRegisterMBeanForThreadPool();
    }

    private void tryToRegisterMBeanForThreadPool() {
        try {
            ThreadPoolMXBeanImpl mbean = new ThreadPoolMXBeanImpl(this);
            MBeanServer mbs = ManagementFactory.getPlatformMBeanServer();
            ObjectName mBeanName = mbean.getObjectName();
            mbs.registerMBean(mbean, mBeanName);
        }
        catch (InstanceAlreadyExistsException | MBeanRegistrationException | MalformedObjectNameException | NotCompliantMBeanException e) {
            logger.warning("Couldn't register MBean for thread pool executor " + this.getName() + ": " + e.getMessage());
        }
    }

    @Override
    public void terminated() {
        super.terminated();
        try {
            ThreadPoolMXBeanImpl mbean = new ThreadPoolMXBeanImpl(this);
            MBeanServer mbs = ManagementFactory.getPlatformMBeanServer();
            ObjectName mBeanName = mbean.getObjectName();
            mbs.unregisterMBean(mBeanName);
        }
        catch (InstanceNotFoundException | MBeanRegistrationException | MalformedObjectNameException e) {
            logger.log(Level.SEVERE, "Couldn't unregister MBean for thread pool executor " + this.getName(), e);
        }
    }

    public String getName() {
        return this.name;
    }

    @Override
    protected <V> RunnableScheduledFuture<V> decorateTask(Runnable runnable, RunnableScheduledFuture<V> task) {
        return new ThreadPoolAwareRunnableScheduledFutureDelegate<V>(this, task);
    }

    @Override
    protected <V> RunnableScheduledFuture<V> decorateTask(Callable<V> callable, RunnableScheduledFuture<V> task) {
        return new ThreadPoolAwareRunnableScheduledFutureDelegate<V>(this, task);
    }

    @Override
    protected <T> RunnableFuture<T> newTaskFor(Runnable runnable, T value) {
        return new ThreadPoolAwareFutureTask<T>(this, runnable, value);
    }

    @Override
    protected <T> RunnableFuture<T> newTaskFor(Callable<T> callable) {
        return new ThreadPoolAwareFutureTask<T>(this, callable);
    }

    @Override
    public void execute(Runnable command) {
        if (command instanceof KnowsExecutor) {
            ((KnowsExecutor)((Object)command)).setExecutorThisTaskIsScheduledFor(this);
        }
        super.execute(command);
    }

    @Override
    protected void beforeExecute(Thread t, Runnable r) {
        super.beforeExecute(t, r);
        if (logger.isLoggable(Level.FINE)) {
            this.startTimePoints.put(r, MillisecondsTimePoint.now());
        }
    }

    @Override
    protected void afterExecute(Runnable r, Throwable t) {
        if (logger.isLoggable(Level.FINE)) {
            TimePoint end = MillisecondsTimePoint.now();
            TimePoint startTime = this.startTimePoints.remove(r);
            Runnable theRunnableToLog = null;
            if (r instanceof ScheduledFuture) {
                theRunnableToLog = (Runnable)this.wrappedRunnables.get((Object)((ScheduledFuture)((Object)r)));
            }
            if (theRunnableToLog == null) {
                theRunnableToLog = r;
            }
            if (startTime != null) {
                Duration duration = startTime.until(end);
                if (duration.compareTo((Object)this.DURATION_LOGGING_THRESHOLD) > 0) {
                    logger.fine("Runnable " + theRunnableToLog + " took " + duration + " to complete in executor " + this + (t == null ? "" : ". It failed with exception " + t));
                }
            } else {
                logger.fine("Strange internal problem: had expected to find start time for " + r);
            }
        }
        super.afterExecute(r, t);
    }

    @Override
    public ScheduledFuture<?> schedule(Runnable command, long delay, TimeUnit unit) {
        ScheduledFuture<?> result = super.schedule(command, delay, unit);
        if (logger.isLoggable(Level.FINE)) {
            this.wrappedRunnables.put(result, (Object)command);
        }
        return result;
    }

    @Override
    public ScheduledFuture<?> scheduleAtFixedRate(Runnable command, long initialDelay, long period, TimeUnit unit) {
        ScheduledFuture<?> result = super.scheduleAtFixedRate(command, initialDelay, period, unit);
        if (logger.isLoggable(Level.FINE)) {
            this.wrappedRunnables.put(result, (Object)command);
        }
        return result;
    }

    @Override
    public ScheduledFuture<?> scheduleWithFixedDelay(Runnable command, long initialDelay, long delay, TimeUnit unit) {
        ScheduledFuture<?> result = super.scheduleWithFixedDelay(command, initialDelay, delay, unit);
        if (logger.isLoggable(Level.FINE)) {
            this.wrappedRunnables.put(result, (Object)command);
        }
        return result;
    }

    @Override
    public String toString() {
        return String.valueOf(super.toString()) + "[name=" + this.name + "]";
    }
}

