/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sse.util.impl;

import com.sap.sse.common.Duration;
import com.sap.sse.util.impl.HasTracingGet;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.logging.Level;
import java.util.logging.Logger;

public abstract class HasTracingGetImpl<V>
implements HasTracingGet<V> {
    private static final Logger logger = Logger.getLogger(HasTracingGetImpl.class.getName());
    private final long MILLIS_AFTER_WHICH_TO_TRACE_NON_RETURNING_GET = Duration.ONE_SECOND.times(5L).asMillis();

    @Override
    public V callGetAndTraceAfterEachTimeout(Future<V> future) throws InterruptedException, ExecutionException {
        while (true) {
            try {
                return future.get(this.MILLIS_AFTER_WHICH_TO_TRACE_NON_RETURNING_GET, TimeUnit.MILLISECONDS);
            }
            catch (TimeoutException e) {
                if (logger.isLoggable(Level.FINE)) {
                    logger.log(Level.FINE, Thread.currentThread() + ": Timeout waiting for future task " + future + " (retrying); " + this.getAdditionalTraceInfo(), e);
                    continue;
                }
                logger.info(Thread.currentThread() + ": Timeout waiting for future task " + future + " (retrying); " + this.getAdditionalTraceInfo());
                continue;
            }
            break;
        }
    }

    protected abstract String getAdditionalTraceInfo();
}

