/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sse.util.apachelog;

import com.sap.sse.common.Util;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.GregorianCalendar;
import java.util.Iterator;
import java.util.TimeZone;

public class PerHostnameEntry {
    private static final SimpleDateFormat dateFormat = new SimpleDateFormat("dd/MMM/yyyy");
    private final String requestorIpString;
    private final String dateString;
    private final String userAgent;
    private final int year;
    private final int zeroBasedMonth;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PerHostnameEntry(String line) {
        int tmpZeroBasedMonth;
        int tmpYear;
        Iterator i = Util.splitAlongWhitespaceRespectingDoubleQuotedPhrases((String)line).iterator();
        this.requestorIpString = (String)i.next();
        this.dateString = (String)i.next();
        StringBuilder userAgentBuilder = new StringBuilder();
        while (i.hasNext()) {
            userAgentBuilder.append((String)i.next());
            if (!i.hasNext()) continue;
            userAgentBuilder.append(' ');
        }
        this.userAgent = userAgentBuilder.toString();
        GregorianCalendar cal = new GregorianCalendar(TimeZone.getTimeZone("UTC"));
        try {
            SimpleDateFormat simpleDateFormat = dateFormat;
            synchronized (simpleDateFormat) {
                cal.setTime(dateFormat.parse(this.dateString));
            }
            tmpYear = cal.get(1);
            tmpZeroBasedMonth = cal.get(2);
        }
        catch (ParseException e) {
            tmpYear = 0;
            tmpZeroBasedMonth = 0;
        }
        this.zeroBasedMonth = tmpZeroBasedMonth;
        this.year = tmpYear;
    }

    public String getRequestorIpString() {
        return this.requestorIpString;
    }

    public String getDateString() {
        return this.dateString;
    }

    public String getUserAgent() {
        return this.userAgent;
    }

    public int getYear() {
        return this.year;
    }

    public int getZeroBasedMonth() {
        return this.zeroBasedMonth;
    }
}

