/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sse.util;

import com.sap.sse.common.Duration;
import com.sap.sse.common.Util;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.function.Function;
import java.util.logging.Logger;
import org.apache.shiro.SecurityUtils;
import org.apache.shiro.subject.Subject;

public class SingleCalculationPerSubjectCache<K, V> {
    private static final Logger logger = Logger.getLogger(SingleCalculationPerSubjectCache.class.getName());
    private final ConcurrentMap<Util.Pair<K, String>, Future<V>> ongoingLiveCalculationsByRaceAndRequestingUsername = new ConcurrentHashMap<Util.Pair<K, String>, Future<V>>();
    private final Function<K, V> functionCalculatingValueForKey;
    private final Duration timeoutBeforeCalculatingInPlace;

    public SingleCalculationPerSubjectCache(Function<K, V> functionCalculatingValueForKey, Duration timeoutBeforeCalculatingInPlace) {
        this.functionCalculatingValueForKey = functionCalculatingValueForKey;
        this.timeoutBeforeCalculatingInPlace = timeoutBeforeCalculatingInPlace;
    }

    public V get(K key) {
        Object result;
        Subject subject = SecurityUtils.getSubject();
        String username = subject == null ? null : (subject.getPrincipal() == null ? null : subject.getPrincipal().toString());
        Util.Pair cacheKey = new Util.Pair(key, (Object)username);
        Future ongoingLiveCalculationForTrackedRace = (Future)this.ongoingLiveCalculationsByRaceAndRequestingUsername.get(cacheKey);
        if (ongoingLiveCalculationForTrackedRace != null) {
            try {
                if (this.timeoutBeforeCalculatingInPlace == null) {
                    result = ongoingLiveCalculationForTrackedRace.get();
                }
                result = ongoingLiveCalculationForTrackedRace.get(this.timeoutBeforeCalculatingInPlace.asMillis(), TimeUnit.MILLISECONDS);
            }
            catch (InterruptedException | ExecutionException e) {
                throw new RuntimeException("Error computing function for key " + key, e);
            }
            catch (TimeoutException toe) {
                logger.warning("Timeout waiting for ongoing function evaluation for " + key + "; computing in place now");
                result = this.functionCalculatingValueForKey.apply(key);
            }
        } else {
            CompletableFuture ongoingCalculation = new CompletableFuture();
            this.ongoingLiveCalculationsByRaceAndRequestingUsername.put(cacheKey, ongoingCalculation);
            try {
                try {
                    result = this.functionCalculatingValueForKey.apply(key);
                    ongoingCalculation.complete(result);
                }
                catch (Exception e) {
                    ongoingCalculation.completeExceptionally(e);
                    throw e;
                }
            }
            finally {
                this.ongoingLiveCalculationsByRaceAndRequestingUsername.remove(cacheKey);
            }
        }
        return result;
    }
}

