/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sse.util;

import com.sap.sse.common.IsManagedByCache;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectStreamClass;
import java.util.Map;

public abstract class ObjectInputStreamResolvingAgainstCache<C>
extends ObjectInputStream {
    private final C cache;
    private final Map<String, Class<?>> classLoaderCache;
    private ResolveListener resolveListener;

    protected ObjectInputStreamResolvingAgainstCache(InputStream in, C cache, ResolveListener resolveListener, Map<String, Class<?>> classLoaderCache) throws IOException {
        super(in);
        assert (cache != null);
        this.cache = cache;
        this.resolveListener = resolveListener;
        assert (classLoaderCache != null);
        this.classLoaderCache = classLoaderCache;
        this.enableResolveObject(true);
    }

    private C getCache() {
        return this.cache;
    }

    @Override
    protected Class<?> resolveClass(ObjectStreamClass classDesc) throws ClassNotFoundException {
        String className = classDesc.getName();
        try {
            return this.classLoaderCache.computeIfAbsent(className, cn -> {
                try {
                    return Class.forName(cn, true, Thread.currentThread().getContextClassLoader());
                }
                catch (ClassNotFoundException e) {
                    throw new RuntimeException(e);
                }
            });
        }
        catch (RuntimeException e) {
            if (e.getCause() != null && e.getCause() instanceof ClassNotFoundException) {
                throw (ClassNotFoundException)e.getCause();
            }
            throw e;
        }
    }

    @Override
    protected Object resolveObject(Object o) {
        Object result;
        if (o instanceof IsManagedByCache) {
            IsManagedByCache castResult = ((IsManagedByCache)o).resolve(this.getCache());
            result = castResult;
        } else {
            result = o;
        }
        if (this.resolveListener != null) {
            if (o == result) {
                this.resolveListener.onResolvedObject(result);
            } else {
                this.resolveListener.onNewObject(result);
            }
        }
        return result;
    }

    public static interface ResolveListener {
        public void onNewObject(Object var1);

        public void onResolvedObject(Object var1);
    }
}

