/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sse.rest;

import java.io.BufferedWriter;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import javax.ws.rs.core.StreamingOutput;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;

public class StreamingOutputUtil {
    protected StreamingOutput streamingOutput(final JSONObject jsonObject) {
        return new StreamingOutput(){

            public void write(OutputStream output) throws IOException {
                BufferedWriter bufferedWriter = new BufferedWriter(new OutputStreamWriter(output, "UTF8"));
                jsonObject.writeJSONString((Writer)bufferedWriter);
                bufferedWriter.flush();
            }
        };
    }

    protected StreamingOutput streamingOutput(final JSONArray jsonArray) {
        return new StreamingOutput(){

            public void write(OutputStream output) throws IOException {
                BufferedWriter bufferedWriter = new BufferedWriter(new OutputStreamWriter(output, "UTF8"));
                jsonArray.writeJSONString((Writer)bufferedWriter);
                bufferedWriter.flush();
            }
        };
    }

    public static String getEntityAsString(Object entity) throws IOException {
        if (entity instanceof StreamingOutput) {
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            ((StreamingOutput)entity).write((OutputStream)bos);
            return bos.toString("UTF8");
        }
        String result = entity.toString();
        return result;
    }
}

